package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * @author zhangbin
 * @date 2018/4/10.
 */
@Data
@Entity
@Table(name = "callback_record", catalog = "cash_loan_flow")
public class CallbackRecord {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;
    /**
     * 量化派授信订单号，申请订单号
     */
    @Column(name = "apply_no")
    private String applyNo;
    /**
     * xyqb.loan_application_history.id
     */
    @Column(name = "loan_id")
    private Long loanId;
    /**
     * 还款计划期数
     */
    @Column(name = "term_no")
    private Long termNo;
    /**
     * 渠道订单标识
     */
    @Column(name = "channel_id")
    private Long channelId;
    /**
     * 映射成渠道推送状态
     */
    @Column(name = "callback_status")
    private Integer callbackStatus;
    /**
     * 事件
     */
    @Column(name = "notice_type")
    private KANoticeType noticeType;
    /**
     * 成功次数
     */
    @Column(name = "success_times")
    private Long successTimes;

    @Column(name = "is_active")
    private Boolean isActive;

    @Column(name = "created_at")
    private Timestamp createdAt = Timestamp.from(Instant.now());

    @Column(name = "updated_at")
    private Timestamp updatedAt = Timestamp.from(Instant.now());

}
