package cn.quantgroup.cashloanflowboss.spi.opapi.service;

import cn.quantgroup.cashloanflowboss.spi.opapi.OPCenter;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * function:
 * date: 2019/10/25
 *
 * @author: suntao
 */
@Service
public class OPCenterServiceImpl implements OPCenterService {


    @Autowired
    private OPCenter opCenter;

    @Override
    public String getToken(String auth) {
        return opCenter.getToken(auth);
    }

    @Override
    public String clothoFundsPlanLoanApply(Integer fundingCorpId) {

        Map<String, Object> param = new HashMap<>(4);
        param.put("fundingCorpId", fundingCorpId);
        param.put("amountLimit", 10000L);
        param.put("peopleLimit", 1000L);
        return opCenter.clothoFundsPlanLoanApply(JSONTools.serialize(param));
    }
}
