package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ResposeResultEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.RepaymentPlatService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.RepaymentPlan;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.IRepaymentPlanRepository;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/24.
 */
@Slf4j
@Service
public class RepaymentPlatServiceImpl implements RepaymentPlatService {
    @Autowired
    private IRepaymentPlanRepository iRepaymentPlanRepository;
    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Value("${mapi.http.net}")
    private String mapiHttp;
    @Value("${pay.http.net}")
    private String payHttp;
    @Override
    public Result whetherHaveRepayment0rdersList(OneClickData oneClickData) {
        try {
        List<RepaymentPlan> repaymentPlanList=greRepaymentList(oneClickData.getLoanId());

        if(repaymentPlanList.size()>0){

                String token=phoneInfoService.getToken(oneClickData.getPhone(), oneClickData.getChannelCode());

               log.info("获取oneClickData={},token={}",oneClickData,token);
                  if( StringUtils.isNotEmpty(token)){
                      JSONObject resultRepaymentOrdersList= getRepaymentOrdersList(oneClickData.getLoanId(), token, oneClickData);

                      return Result.buildSuccess(resultRepaymentOrdersList,"返回结果值");

                  }else {
                      log.info("token信息有问题，token={}",token);

                      return Result.buildFail("token信息有问题");
                  }


        }else {
            return Result.buildFail("token信息有问题");

        }
        }catch (Exception e){
            log.info("获取token失败e={}",e);
            return  Result.buildFail("进入异常中。。。");

        }
    }

    public List<RepaymentPlan> greRepaymentList(String loanId){
       return iRepaymentPlanRepository.findByLoanApplicationHistoryIdAndRepaymentStatusAndCurrentRepayment(Long.parseLong(loanId));

    }
    @Override
    public JSONObject getRepaymentOrdersList(String loanID, String token,OneClickData oneClickData) {
        String url= mapiHttp+"/xjd/repayment/plans";

        Map<String, String> paras =new HashMap<String, String>();
        paras.put("id", loanID);
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("X-Auth-Token", token);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        String businessCode=result.get("businessCode").toString().trim();
        if(businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            String repaymentToken= getRepaymentToken( oneClickData.getLoanId().trim(),  token);
            if(StringUtils.isNotEmpty(repaymentToken)){
              return  IsGetCardListInfo( repaymentToken, oneClickData);
            }else {
                return result;
            }

        }else {
            return result;

        }
    }


    public JSONObject IsGetCardListInfo(String repaymentToken,OneClickData oneClickData){
        JSONObject resultGetCardListInfo= getCardListInfo(repaymentToken, oneClickData);
        String businessCodeGetCardListInfo=resultGetCardListInfo.get("businessCode").toString().trim();
        if(!Objects.isNull(resultGetCardListInfo) && businessCodeGetCardListInfo.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            return resultGetCardListInfo;
        }else {
            return resultGetCardListInfo;
        }
    }

    @Override
    public String getRepaymentToken(String loanID, String token) {
        String repaymentToken="";
        String url= mapiHttp+"/xjd/paycenter/repay";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("id",loanID);
        paras.put("singleServiceFeePlanId","");
        paras.put("serviceFeeOnly","");
        paras.put("couponBusinessId","");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("X-Auth-Token", token);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("打印一下result={}",result);
        String businessCode=result.get("businessCode").toString().trim();
        if(!Objects.isNull(result) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
           String data=result.get("data").toString().trim();
            if(StringUtils.isNotEmpty(data)){
                repaymentToken=result.get("data").toString().trim().split("//?")[2].split("&")[0].split("=")[1];
            }

        }else {
            log.info("获取的reslut是空={}", result);
            return repaymentToken;
        }

        return repaymentToken;
    }

    @Override
    public JSONObject getCardListInfo(String repaymentToken,OneClickData oneClickData) {
        String url= mapiHttp+"/pay/common/bank_card/card_list";
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        String referer=payHttp+"/repay-card-list?enter=true";
        header.put("Referer", referer);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url, null, header);
        String businessCode=result.get("businessCode").toString().trim();
        if(!Objects.isNull(result) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            JSONObject data=(JSONObject) result.get("data");
            if (!Objects.isNull(data)){
                log.info("获取卡信息的reslut={}",result);
               boolean isRight=isCardInfo(data, oneClickData.getId());
                //是继续调用金额还是重新绑卡确认
               isPayMoneyInfo(isRight,repaymentToken,oneClickData);


            }else {
                return result;
            }
        }

        return result;
    }


    public boolean isPayMoneyInfo(boolean isRight,String repaymentToken,OneClickData oneClickData){
        boolean result=true;
        if(isRight){  // 如果获取到了卡信息cardBindInfoId 调用获取金额信息接口
            JSONObject payMoneyInfoResult=getPayMoneyInfo(repaymentToken);
            // 是否继续走支付确认页面
         isPaymentConfirmation(payMoneyInfoResult,repaymentToken,oneClickData);

        }else {
            log.info("卡中不存在cardBindInfoId，需要确认绑定");
            //通过id获取最新的当前的手机号的绑卡信息
            OneClickData oneClickData1=oneClickDataRespository.findByLoanId(oneClickData.getLoanId());
           boolean isOk= isBangCardConfirmFlow(repaymentToken, oneClickData1);
            if(isOk){
                    //绑卡成功了重新调用获取卡信息走流程
                getCardListInfo(repaymentToken, oneClickData);
                result=true;
            }else{
                result=false;
            }
        }
        return  result;

    }

    public boolean isPaymentConfirmation(JSONObject payMoneyInfoResult,String repaymentToken,OneClickData oneClickData){
        boolean result=true;
       String businessCode=payMoneyInfoResult.get("businessCode").toString().trim();
        if(!Objects.isNull(payMoneyInfoResult) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            JSONObject paymentConfirmationResult= paymentConfirmation(oneClickData, repaymentToken);

            boolean isOk=isPayFlow(repaymentToken,paymentConfirmationResult,oneClickData);
            if(isOk){
                log.info("支付成功");
                result=true;
            }else {
                log.info("支付失败");
                result=false;
            }
        }
        return  result;
    }

    public boolean isCardInfo(JSONObject result,Long id){
        JSONObject dataObject=result;
        JSONArray cardList=(JSONArray) dataObject.get("cardList");
        if(!Objects.isNull(cardList)){
            JSONObject cardListObject=(JSONObject)cardList.get(0);
            String  payApproach=cardListObject.get("payApproach").toString().trim();
            String preservePhoneNo=cardListObject.get("preservePhoneNo").toString().trim();
            String cardId= cardListObject.get("id").toString().trim();
            String  cardBindInfoId ="";
            log.info("获取当前的cardListObject={}",cardListObject);
         String cardBindInfoIdKey="cardBindInfoId";
            if(cardListObject.toString().contains(cardBindInfoIdKey)) {
                cardBindInfoId=cardListObject.get("cardBindInfoId").toString().trim();
               String getValue="0";
                if(cardBindInfoId.equals(getValue)){
                    //修改卡信息保存到表中,并且当前的cardBindInfoId没有值
                    updateCardInfo(payApproach,preservePhoneNo,cardId,cardBindInfoId,id);
                    return false;
                }else {
                    //修改卡信息保存到表中
                    updateCardInfo(payApproach,preservePhoneNo,cardId,cardBindInfoId,id);
                    return true;
                }

            }else{
                //修改卡信息保存到表中
                updateCardInfo(payApproach,preservePhoneNo,cardId,"",id);
                return false;
            }
        }else {
            return false;
        }
    }




    public boolean isBangCardConfirmFlow(String repaymentToken,OneClickData oneClickData1){
        boolean result=true;
        String cardId=oneClickData1.getCardId();
        String preservePhoneNo=oneClickData1.getPreservePhoneNo();
        String payApproach=oneClickData1.getPayApproach();
        boolean isTrue=StringUtils.isNotEmpty(repaymentToken) && StringUtils.isNotEmpty(cardId) && StringUtils.isNotEmpty(preservePhoneNo) && StringUtils.isNotEmpty(payApproach);
       if(isTrue) { //卡基础信息不是空，进行绑卡流程
           // 绑卡确认流程是否成功
          boolean isOk= bangCardConfirmFlow(repaymentToken, oneClickData1);
           if(isOk){
               log.info("绑卡成功");
               result=true;
           }else{
               log.info("绑卡失败");
               result=false;
           }
       }else {
           log.info("获取卡基础信息失败");
           result=false;
       }
        return result;
    }

    public boolean bangCardConfirmFlow(String repaymentToken, OneClickData oneClickData1){
        String cardId=oneClickData1.getCardId();
        String preservePhoneNo=oneClickData1.getPreservePhoneNo();
        String payApproach=oneClickData1.getPayApproach();
        boolean isSuccBand=true;
        JSONObject getBingCard=bingCard(repaymentToken, cardId, preservePhoneNo, payApproach);
       String statusCode=getBingCard.get("statusCode").toString().trim();

        if(!Objects.isNull(getBingCard) && statusCode.equals(ResposeResultEnum.STATUSCODEONE.getDesc())){
            JSONObject getbingCardSms=bingCardSms(repaymentToken, cardId, preservePhoneNo, payApproach);
            String businessCode=getbingCardSms.get("businessCode").toString().trim();
            if(businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
                JSONObject  getbingCardSmsConfirm=bingCardSmsConfirm(repaymentToken, cardId, payApproach);
                String businessCodeend=getbingCardSmsConfirm.get("businessCode").toString().trim();

                if(!Objects.isNull(getbingCardSmsConfirm) && businessCodeend.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
                    isSuccBand=true;
                 }else {
                    isSuccBand=false;

                }
            }else {
                isSuccBand=false;

            }

        }else {
            isSuccBand=false;
        }
        return isSuccBand;
    }




   public void updateCardInfo(String payApproach,String preservePhoneNo,String cardId,String cardBindInfoId,Long id){
       // 卡信息被保存到表里面
       int num=oneClickDataRespository.updateBankInfoById(payApproach, preservePhoneNo, cardId, cardBindInfoId, id);
       if(num >0){
           log.info("修改卡信息成功");
       }else{
           log.info("修改卡信息失败");
       }
   }


    public boolean isPayFlow(String repaymentToken,JSONObject paymentConfirmationResult,OneClickData oneClickData){
        boolean result=true;
        String businessCode= paymentConfirmationResult.get("businessCode").toString().trim();
        if(!Objects.isNull(paymentConfirmationResult) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            JSONObject bankCardAuthenticationInformationResult=bankCardAuthenticationInformation(repaymentToken);
            log.info("打印bankCardAuthenticationInformationResult={}",bankCardAuthenticationInformationResult);
            String bankCardAuthenticationInformationBusinessCode=bankCardAuthenticationInformationResult.get("businessCode").toString().trim();
            if (!Objects.isNull(bankCardAuthenticationInformationResult) && bankCardAuthenticationInformationBusinessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){

                JSONObject sendSmsResult= sendSMS(repaymentToken);
                boolean isOk=isConfirmPayment(repaymentToken,sendSmsResult);
                if(isOk){
                    result=true;
                }else {
                    result=false;
                }

            }else {
                result=false;
            }
        }else {// 支付页面返回失败，则重新检查当前是否有需要还款的单，如有重新执行一遍
                   whetherHaveRepayment0rdersList(oneClickData);

        }
        return result;
    }


    public boolean isConfirmPayment(String repaymentToken,JSONObject sendSmsResult){
        boolean result=true;
        String businessCode= sendSmsResult.get("businessCode").toString().trim();
        if(!Objects.isNull(sendSmsResult) && businessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
            JSONObject confirmPaymentResult=confirmPayment(repaymentToken);
            String confirmPaymentResultBusinessCode=confirmPaymentResult.get("businessCode").toString().trim();
            if (!Objects.isNull(confirmPaymentResult) && confirmPaymentResultBusinessCode.equals(ResposeResultEnum.BUSINESSCODE.getDesc())){
                result=true;
            }else {
                result=false;
            }
        }else {
            result=false;
        }
        return result;
    }

    @Override
    public JSONObject getPayMoneyInfo(String repaymentToken) {
        String url= mapiHttp+"/pay/common/order/repay/amount";
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        String referer=payHttp+"/repay-card-list?enter=true";
        header.put("Referer", referer);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url,null, header);


        return result;
    }

    @Override
    public JSONObject paymentConfirmation(OneClickData oneClickData,String repaymentToken) {
        String url= mapiHttp+"/pay/common/bank_card/make_bind_relation";
        String param="cardBindInfoId="+oneClickData.getCardBindInfoId()+"&cardId="+oneClickData.getCardId();
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url,param, header);
        return result;
    }

    @Override
    public JSONObject bankCardAuthenticationInformation(String repaymentToken) {
        String url= mapiHttp+"/pay/common/order/repay/init_new";
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url,null, header);
       log.info("银行卡信息认证结果result={}",result);
        return result;
    }

    @Override
    public JSONObject sendSMS(String repaymentToken) {
        String url= mapiHttp+"/pay/order/repay/sms?firstEnter=0";
        Map<String, String> paras =new HashMap<String, String>();
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        return result;
    }

    @Override
    public JSONObject confirmPayment(String repaymentToken) {
        String url= mapiHttp+"/pay/order/repay/sms_validate?validateCode=000000";
        Map<String, String> paras =new HashMap<String, String>();
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        header.put("Content-Type", "application/json;charset=UTF-8");
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        return result;
    }

    @Override
    public JSONObject bingCard(String repaymentToken, String cardId ,String preservePhoneNo,String payApproach) {
        String url= payHttp+"/card-validate";
        String paras ="bankCardId="+cardId+"&preservePhoneNo="+preservePhoneNo+"&payApproach="+payApproach;
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url, paras, header);
        return result;
    }

    @Override
    public JSONObject bingCardSms(String repaymentToken,String cardId,String preservePhoneNo,String payApproach ) {
        String url= mapiHttp+"/pay/bank_card/pay_approach/sms";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("bankCardId",cardId);
        paras.put("preservePhoneNo",preservePhoneNo);
        paras.put("payApproach",payApproach);
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        return result;
    }

    @Override
    public JSONObject bingCardSmsConfirm(String repaymentToken, String cardId,String payApproach) {
        String url= mapiHttp+"/pay/bank_card/pay_approach/sms_confirm";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("bankCardId",cardId);
        paras.put("validateCode","000000");
        paras.put("payApproach",payApproach);
        Map<String, String> header =new HashMap<String, String>();
        header.put("X-Auth-Token", repaymentToken);
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        return result;
    }
}
