package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;


import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.RepaymentPlan;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.sql.Timestamp;
import java.util.List;


/**
 * Created by root on 15-7-23.
 */
@XYQBDataSource
@Repository
public interface IRepaymentPlanRepository extends JpaRepository<RepaymentPlan, Long> {

    List<RepaymentPlan> findByLoanApplicationHistoryIdOrderByTermNoAsc(Long loanApplicationHistoryId);

    List<RepaymentPlan> findByPayCenterOrderNo(String payCenterOrderNo);

    List<RepaymentPlan> findByUserId(long userid);

    @Query(value = "SELECT * FROM xyqb.repayment_plan t WHERE t.loan_application_history_id = ?1 AND t.repayment_status in (0,2) AND current_repayment=0.00 order by t.term_no asc", nativeQuery = true)
    List<RepaymentPlan> findByLoanApplicationHistoryIdAndRepaymentStatusAndCurrentRepayment(Long loanId);

    List<RepaymentPlan> findByLoanApplicationHistoryIdAndTermNo(Long loanId, Integer termNo);

    RepaymentPlan findById(Long id);

    List<RepaymentPlan> findByLoanApplicationHistoryId(Long loanId);

    @Query(value = "SELECT * FROM xyqb.repayment_plan t WHERE user_id = ?1 AND loan_application_history_id = ?2", nativeQuery = true)
    List<RepaymentPlan> findByUserIdAndLoanId(Long userId, Long loanId);

    /**l
     * 提前结清，更新还款状态为成功
     *
     * @return
     */
    @Modifying
    @Query(value = "update repayment_plan set repayment_status = 3,remark ='提前结清' ,repaid_at=?2 ,repayment_received_at=?2 where id=?1", nativeQuery = true)
    int repaySuccess(Long id, Timestamp timestamp);


    /**
     * 批量更新还款计划状态.
     *
     * @return
     */
    @Modifying
    @Query(value = "update repayment_plan set repayment_status = ?2,remark ='小牛退课' WHERE id in ?1", nativeQuery = true)
    int updateRepaymentPlanByIds(List<Long> ids, Integer status);

    @Modifying
    @Query(value = "update repayment_plan set repayment_status = ?2,remark =?3 WHERE loan_application_history_id = ?1", nativeQuery = true)
    int updateRepaymentPlanByLoanId(Long loanId, Integer status, String remark);
}
