package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.CommonType;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.H5BindingCardAndWithdrawDeposit;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaAccount;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.IQuotaAccountRepository;
import cn.quantgroup.cashloanflowboss.utils.BankCardNumberGenerator;
import cn.quantgroup.cashloanflowboss.utils.BankCardTypeEnum;
import cn.quantgroup.cashloanflowboss.utils.BankNameEnum;
import cn.quantgroup.cashloanflowboss.utils.CommonConstant;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2020/1/21.
 */
@Slf4j
@Service
public class H5BindingCardAndWithdrawDepositImpl implements H5BindingCardAndWithdrawDeposit {
    @Value("${api.http.net}")
    private String apiHttp;
    @Value("${payapi.http.net}")
    private String payapiHttp;
    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private IQuotaAccountRepository iQuotaAccountRepository;
    private String payToken="";
    private String accountId="";
    @Override
    public void accountPro(OneClickData oneClickData) throws Exception {
        log.info("打印一下productid: " + oneClickData.getProductId());
        String productId=oneClickData.getProductId();
        String url= apiHttp+"/v3/quota/account/pro/"+productId;
        Map<String, String> paras =new HashMap<String, String>();
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
       String token= phoneInfoService.getToken(oneClickData.getPhone(),oneClickData.getChannelCode());
        header.put("x-auth-token", token);


        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("打印result={}", result);
//        if(!result.get("businessCode").toString().trim().equals("0000")){
//            FundsAllocationplan fundsallocationplan= new FundsAllocationplan();
//            fundsallocationplan.resetData();
//            fundsallocationplan.testloginOP();
//            fundsallocationplan.testFundingPlan();
//            fundsallocationplan.testFundingPolicySave();
//            num++;
//            if(num<=3) {
//                testAccountPro();
//            }
//        }

    }

    @Override
    public QuotaAccount getXYQBAccountId(OneClickData oneClickData) {
        QuotaAccount quotaAccount=iQuotaAccountRepository.findLatestAccount(Long.parseLong(oneClickData.getUserId()),Long.parseLong(oneClickData.getProductId()) );
        return quotaAccount;
    }

    @Override
    public void bindCard(OneClickData oneClickData) throws Exception {
        String url=apiHttp+"/v3/bind_card/new";
        Map<String, String> paras =new HashMap<String, String>();
        paras.put("accountId", accountId);
        paras.put("cardType","0");
        String callback=apiHttp+"/loan/cycle-card";
        paras.put("callback",callback);
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String token= phoneInfoService.getToken(oneClickData.getPhone(),oneClickData.getChannelCode());
        header.put("x-auth-token", token);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("打印结果={} " , result);
        payToken=result.get("data").toString().trim().split("\\?")[1].split("&")[0].split("=")[1].toString().trim();
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
    }

    @Override
    public void cardAuthSms(OneClickData oneClickData) {
        String url= payapiHttp+"/card_auth/sms";

        Map < String, String > paras = new HashMap<String, String>();
        String cardBank= BankNameEnum.ICBC.name();
        String cardNo= BankCardNumberGenerator.generate(BankNameEnum.ICBC, BankCardTypeEnum.DEBIT);
        paras.put("cardNo",cardNo);
        paras.put("preservePhoneNo",oneClickData.getPhone());
        paras.put("province","110000");
        paras.put("city","110101");
        paras.put("bankCode",cardBank);
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", payToken);


        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
    }

    @Override
    public void cardAuthSmsConfirm(OneClickData oneClickData,String cardNo) {
        String url= payapiHttp+"/card_auth/sms_confirm";

        Map < String, String > paras = new HashMap<String, String>();
        paras.put("cardNo",cardNo);
        paras.put("province","110000");
        paras.put("city","110101");
        paras.put("validateCode","000000");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", payToken);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");

    }

    @Override
    public void bindCardList(OneClickData oneClickData) throws Exception {
        String url=apiHttp+"/v3/bind_card/list";

        String paras ="accountId="+accountId+"&cardType=0";
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String token= phoneInfoService.getToken(oneClickData.getPhone(),oneClickData.getChannelCode());
        header.put("x-auth-token", token);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url, paras, header);


        if(!result.get("data").toString().isEmpty()){
            JSONArray resultData=(JSONArray)result.get("data");
            JSONObject getParam=(JSONObject)resultData.get(0);
           String cardIdNew=getParam.get("id").toString().trim();
           String cardBindInfoIdNew=getParam.get("cardBindInfoId").toString().trim();
        }

        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
    }

    @Override
    public void accountTrial(OneClickData oneClickData) throws Exception{
        String url= apiHttp+"/v3/quota/account/trial";
        String accountId="";
        String txAmount="";
        String term="";
        String paras ="accountId="+accountId+"&amount="+txAmount+"&termNo="+term;
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String token= phoneInfoService.getToken(oneClickData.getPhone(),oneClickData.getChannelCode());
        header.put("x-auth-token", token);
        JSONObject result= HttpRequest.doGetReturnResponseJson(url, paras, header);
        log.info("打印reslut结果：   " + result);
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
    }

    @Override
    public void cashAfterBindingCard(OneClickData oneClickData) throws Exception {
        String url= apiHttp+"/v3/quota/loan/createLoan";
        Map<String, String> paras =new HashMap<String, String>();

        String term="";
        String accountId="";
        String productId="";
        String cardId="";
        String cardBindInfoId="";
        String creditAmount="";
        String txAmount="";
        String amount=getAmount(Integer.parseInt(productId), creditAmount, txAmount);
        paras.put("amount", amount);
        paras.put("term", term);
        paras.put("accountId", accountId);
        paras.put("productId",String.valueOf(productId) );
        paras.put("cardId", cardId);
        paras.put("cardBindInfoId",cardBindInfoId );
        paras.put("purpose","手机数码" );
        paras.put("dimension", "");
        Map<String, String> header =new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String token= phoneInfoService.getToken(oneClickData.getPhone(),oneClickData.getChannelCode());
        header.put("x-auth-token",token);
        JSONObject result= HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("打印结果={}" + result);
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
    }

    public String getAmount(int productId,String creditAmount,String txAmount){
        String amount1="";
        if (productId == CommonType.PRODUCTTYPEONE.getCode() || productId == CommonType.PRODUCTID900.getCode()) {
            amount1 = creditAmount;
        } else if (productId == CommonType.PRODUCTTYPETWO.getCode()) {
            amount1 = txAmount;
        }
        return amount1;
    }
}
