package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import lombok.Data;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

/**
 * 额度账户
 * Created by jingfeng on 2018/3/21.
 */
@Data
@Entity
@Table(name = "quota_account")
public class QuotaAccount {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * uuid关联风控
     */
    @Column(name = "uuid")
    private String uuid;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 预留字段  客户ID
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 产品id,关联产品表
     */
    @Column(name = "product_id")
    private Long productId;

    /**
     * 产品类型;  0:现金分期;1:白条循环;2:现金循环额度
     *
     */
    @Column(name = "product_type")
    private Integer productType;

    /**
     * 总额度
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 当前可用额度
     */
    @Column(name = "available_amount")
    private BigDecimal availableAmount;

    /**
     * 已使用额度
     */
    @Column(name = "used_amount")
    private BigDecimal usedAmount;

    /**
     * 冻结额度
     */
    @Column(name = "freeze_amount")
    private BigDecimal freezeAmount;

    /**
     * 过期时间，风控提供
     */
    @Column(name = "expire_at")
    private Timestamp expireAt;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 数据是否启用标志位
     */
    @Column(name = "is_active")
    private Boolean isActive = true;

    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    //是否过期
    @Transient
    private boolean expired = false;

    public boolean isExpired() {
        return new Date().after(expireAt);
    }

    public enum AccountStatus {
        NONE(0, "无账户"),
        ACTIVE(1, "账户可用，为过期"),
        ACTIVE_EXPIRE(2, "账户可用，已过期（有未结清的，不能设置不可用）"),
        EXPIRE(3, "不可用，过期");
        private int code;
        private String desc;

        AccountStatus(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }


    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }

}
