package cn.quantgroup.cashloanflowboss.api.customer.entity;

import lombok.Data;

import java.util.List;

/**
 * 客户进件信息
 * @author Wang Xiangwei
 * @version 2020/7/8
 */
@Data
public class CustomerInfo {

    private Long userId;

    private String phoneNo;

    private String uuid;

    /**
     * 是否启用
     */
    private Boolean enable;

    private String name;

    /**
     * 身份证号
     */
    private String idNo;

    private String email;

    /**
     * 收入方式
     */
    private String income;

    /**
     * 收入范围
     */
    private String incomeRange;

    /**
     * 职业
     */
    private String occupation;

    /**
     * 学历
     */
    private String education;

    private Boolean hasCar;

    private Boolean hasSocialSecurity;

    private Boolean hasHouse;

    private Boolean hasCreditCard;

    private String marryStatus;

    private String address;

    private String contactNameA;
    private String contactPhoneA;

    private String contactRelationA;

    private String contactNameB;
    private String contactPhoneB;

    private String contactRelationB;


    private List<RiskInfo> riskInfoList;



    @Data
    class RiskInfo{
        private String key;
        private String name;
        private String value;
        private String success;
    }


}
