package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;


import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.spi.user.service.XyqbUserService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.QuotaCreditRepository;
import cn.quantgroup.cashloanflowboss.utils.GetAuthorization;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class PhoneInfoServiceImpl implements PhoneInfoService {
    public static String token = "";

    @Value("${NAMESPACE}")
    private String nameSpace;

    @Value("${passportapi.http}")
    private String passportapiHttp;

    @Value("${api.http.net}")
    private String apiHttp;
    @Autowired
    private QuotaCreditRepository quotaCreditRepository;
    @Autowired
    private XyqbUserService xyqbUserService;

    public String getToken(String phone,String createdFrom) throws Exception {

        String url = passportapiHttp + "/user/login/fastV1";

        Map<String, String> paras = new HashMap<String, String>();
        paras.put("channelId", "1");
        paras.put("createdFrom", createdFrom);
        paras.put("key", "xyqb");
        paras.put("btRegisterChannelId", "");
        paras.put("dimension", "");
        paras.put("click_id", "");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String verification = GetAuthorization.getAuthorizationEncryption(phone);
        header.put("Authorization", verification);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        JSONObject resultDate = (JSONObject) result.get("data");
        String code=result.get("code").toString().trim();
        String businessCode=result.get("businessCode").toString().trim();
        if("0000".equals(code) && "0000".equals(businessCode)){
            token = resultDate.get("token").toString().trim();

        }else{
            log.info("获取token失败,返回失败原因：{}",result);

        }
        return token;
    }



    /**
     * 同步session到xyqb
     * 返回空
     */
    @Test(description = "同步session到xyqb")
    @Override
    public void sySessionToXYQB() {

        String url = apiHttp + "/ex/login/receive_token?token=" + token;

        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        JSONObject reslut = HttpRequest.doGetReturnResponseJson(url, null, header);
        log.info("获取返回结果,{}", reslut);
        Assert.assertEquals(reslut.get("statusCode").toString().trim(), "0");
    }

    @Override
    public XUser selectUserID(String phone) {
        return xyqbUserService.findUserByPhoneNo(phone);
    }

    @Override
    public void authIdNo() {

    }

    @Override
    public void creditSession() {

    }

    @Override
    public void authBasic2() {

    }

    @Override
    public void authOcrUrl() {

    }

    @Override
    public void ocrAtuhUp() {

    }

    @Override
    public void ocrAtuhDown() {

    }

    @Override
    public void ocrSubmit() {

    }

    @Override
    public void getSpiderCenter() {

    }

    @Override
    public void spiderC() {

    }

    @Override
    public void submitAuth() {

    }

    @Override
    public QuotaCredit selectUserAuditRecords(Long qgUserId,Long channel) {
      return   quotaCreditRepository.findByUserIdAndChannelAndIsActiveAndCreditStatus(qgUserId, channel);
    }

    @Override
    public QuotaCredit selectUserAuditRecordsNotCreditStatus(Long qgUserId,Long channel) {
        return   quotaCreditRepository.findByUserIdAndChannelAndIsActive(qgUserId, channel);
    }

    @Override
    public QuotaCredit selectUserAuditRecords(String applyNo) {
        return quotaCreditRepository.findByorderNoAndIsActive(applyNo);
    }

    @Override
    public void spiderFinishNotic() {

    }

    @Override
    public void spiderReportFinishNotic() {

    }

    @Override
    public void updat800QouteProductType() {

    }


    public static void main(String[] args) throws Exception {
        PhoneInfoServiceImpl phon = new PhoneInfoServiceImpl();
        phon.nameSpace = "arch";
        phon.passportapiHttp = "http://passportapi-arch.liangkebang.net";


        log.info("打印,token={}", phon.getToken("13067912192",""));
//        phon.sySessionToXYQB();
//          String a="222";
//        log.info("[getParamsFromEOS],result={}",a);

    }
}
