package cn.quantgroup.cashloanflowboss.core.configuration.data;

import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup"}, entityManagerFactoryRef = "clfEntityManager", transactionManagerRef = "clfTransactionManager", includeFilters = @ComponentScan.Filter(CashLoanFlowDataSource.class))
public class CashLoanFlowDataSourceConfiguration {

    @Value("${data.clf.url}")
    private String jdbcUrl;

    @Value("${data.clf.password}")
    private String password;

    @Value("${data.clf.username}")
    private String user;

    private String uniquename = "clfDS";

    @Value("${data.clf.pool-size}")
    private Integer poolSize;

    @Bean(name = "clfDataSource")
    @ConfigurationProperties(prefix = "data.clf")
    public DataSource createDataSource() {
        DruidDataSource source = DruidDataSourceBuilder.create().build();
        source.setMaxActive(200);
        source.setMinIdle(10);
        source.setInitialSize(10);
        source.setMaxWait(500000);
        source.setTimeBetweenEvictionRunsMillis(60000);
        source.setMinEvictableIdleTimeMillis(300000);
        source.setValidationQuery("SELECT 'x'");
        source.setTestWhileIdle(true);
        source.setTestOnBorrow(false);
        source.setTestOnReturn(false);
        source.setPoolPreparedStatements(Boolean.FALSE);
        return source;
    }

    @Bean(name = "clfEntityManager")
    public LocalContainerEntityManagerFactoryBean entityManager(EntityManagerFactoryBuilder builder) {

        return builder.dataSource(createDataSource())
                .packages("cn.quantgroup.cashloanflowboss.spi.clf.entity")
                .persistenceUnit(uniquename)
                .build();
    }

    @Bean(name = "clfTransactionManager")
    public PlatformTransactionManager transactionManager(@Qualifier("clfEntityManager") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }

}
