package cn.quantgroup.cashloanflowboss.api.login.auth.model;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description: 量星球系统权限缩影
 * @author:tao
 * @create: 2020-07-22 11:29
 */
@Data
public class LxqSystemAuthInfo {
    /**
     * 一个用户在某个系统中可能有多个权限
     * key: systemName
     * value:roles
     */
    private Map<String, List<String>> roles = new HashMap<>();

    /**
     * 构建
     *
     * @param systemName
     * @param role
     * @return
     */
    public LxqSystemAuthInfo build(String systemName, String... role) {
        List<String> existRoles = roles.get(systemName);
        if (CollectionUtils.isEmpty(existRoles)) {
            roles.put(systemName, Arrays.asList(role));
        }
        return this;
    }

    /**
     * 传入系统名称 和 角色名称 是否包含在权限里
     * 需要判断的原因是 同一个系统
     *
     * @param systemName
     * @param role
     * @return
     */
    public boolean isContains(String systemName, String role) {
        if (StringUtils.isAnyBlank(systemName, role)) {
            return false;
        }

        for (Map.Entry<String, List<String>> entry : roles.entrySet()) {
            if (entry.getKey().equals(systemName)) {
                return entry.getValue().contains(role);
            }
        }
        return false;
    }


}
