package cn.quantgroup.cashloanflowboss.api.login.auth;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import java.util.Hashtable;

@Slf4j
public class LDAPAuthentication {
    private final String URL = "ldap://ldap.quantgroups.com:389/";
    private final String BASEDN = "ou=北京量科邦信息技术有限公司,dc=quantgroup,dc=cn";
    private final String FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private LdapContext ctx = null;
    private final Control[] connCtls = null;

    private void ldapConnect() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(Context.INITIAL_CONTEXT_FACTORY, FACTORY);
        env.put(Context.PROVIDER_URL, URL + BASEDN);
        env.put(Context.SECURITY_AUTHENTICATION, "simple");

        String root = "cn=common_auth_query,cn=users,DC=quantgroup,DC=cn";// root
        env.put(Context.SECURITY_PRINCIPAL, root);
        env.put(Context.SECURITY_CREDENTIALS, "Quantgroup.com@2o17");
        // 此处若不指定用户名和密码,则自动转换为匿名登录
        try {
            ctx = new InitialLdapContext(env, connCtls);
        } catch (AuthenticationException e) {
            log.error("验证失败：{}", ExceptionUtils.getStackTrace(e));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }



    private String getUserDN(String uid) {
        String userDN = "";
        ldapConnect();
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
            NamingEnumeration<SearchResult> en = ctx.search("", "uid=" + uid, constraints);
            if (en == null || !en.hasMoreElements()) {
                log.info("未找到该用户,uid={}", uid);
            }
            // maybe more than one element
            while (en != null && en.hasMoreElements()) {
                Object obj = en.nextElement();
                if (obj instanceof SearchResult) {
                    SearchResult si = (SearchResult) obj;
                    userDN += si.getName();
                    userDN += "," + BASEDN;
                } else {
                    System.out.println(obj);
                }
            }
        } catch (Exception e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            e.printStackTrace();
        }

        return userDN;
    }

    public boolean authenricate(String uid, String password) {
        boolean valide = false;
        String userDN = getUserDN(uid);

        try {
            ctx.addToEnvironment(Context.SECURITY_PRINCIPAL, userDN);
            ctx.addToEnvironment(Context.SECURITY_CREDENTIALS, password);
            ctx.reconnect(connCtls);
            log.info("验证通过,uid={}", uid);
            valide = true;
        } catch (AuthenticationException e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            System.out.println(e.toString());
            valide = false;
        } catch (NamingException e) {
            log.error("异常：{}", ExceptionUtils.getStackTrace(e));
            valide = false;
        }

        return valide;
    }

}