package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.api.order.model.RepaymentPlansResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.asserts.Assert;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneService;
import cn.quantgroup.cashloanflowboss.spi.jolyne.JolyneUtil;
import cn.quantgroup.cashloanflowboss.spi.jolyne.model.JolyneDB;
import cn.quantgroup.cashloanflowboss.spi.xyqb.client.XYQBCenter;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.*;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.*;
import cn.quantgroup.cashloanflowboss.spi.xyqb.util.SignUtil;
import cn.quantgroup.cashloanflowboss.utils.DateUtil;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Slf4j
@Service
public class XYQBCenterServiceImpl implements XYQBCenterService {

    @Autowired
    private WaitingFundingCorpOperatePeopleRepository waitingFundingCorpOperatePeopleRepository;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private CancelPreLoanRepository cancelPreLoanRepository;
    @Autowired
    private FundingCorpPolicyRepository fundingCorpPolicyRepository;
    @Autowired
    private FundingAssetAllocationsProgramsRepository fundingAssetAllocationsProgramsRepository;
    @Autowired
    private LoanApplicationHistoryRepository loanApplicationHistoryRepository;
    @Autowired
    private QuotaProductRepository quotaProductRepository;
    @Autowired
    private FinanceProductRepository financeProductRepository;

    @Autowired
    private JolyneService jolyneService;

    @Autowired
    private XYQBCenter xyqbCenter;

    @Autowired
    private IApplyScenarioInfoRepository applyScenarioInfoRepository;


    /**
     * 更新合同状态
     *
     * @param userId
     * @return
     */
    @Override
    public int updateContractStatus(Long userId, Integer status) {
        return this.contractRepository.updateContractStatus(userId, status);
    }

    /**
     * 查询放款记录
     *
     * @param fundId
     * @return
     */
    @Override
    public Map queryLendingRecordCount(Long fundId) {
        return this.waitingFundingCorpOperatePeopleRepository.queryLendingRecordCount(fundId);
    }


    /**
     * 贷前取消借款
     * @param channelOrderNumber
     * @return
     */
    @Override
    public Long cancelPreLoan(String channelOrderNumber) {
        if (Application.isDebug()) {
            return cancelPreLoanRepository.cancelPreLoan(channelOrderNumber);
        } else {
            return -1L;
        }
    }


    /**
     * 通过userId获取合同
     * @param userId
     * @return
     */
    @Override
    public Contract findContractByUserId(Long userId) {
        return contractRepository.findByUserIdLastOne(userId);
    }

    /**
     * 保存合同
     * @param contract
     */
    @Override
    public void saveContract(Contract contract) {
        if (Application.isDebug()) {
            contractRepository.save(contract);
        }
    }


    @Override
    public WaitingFundingCorpOperatePeople findWaitingFundingCorpOperatePeopleByLoanId(Long loanId) {
        return waitingFundingCorpOperatePeopleRepository.findByLoanApplicationHistoryId(loanId);
    }

    @Override
    @Transactional
    public void saveWaitingFundingCorpOperatePeople(WaitingFundingCorpOperatePeople waitingFundingCorpOperatePeople) {
        if (Application.isDebug()) {
            waitingFundingCorpOperatePeopleRepository.saveAndFlush(waitingFundingCorpOperatePeople);
        }
    }


    /**
     * 通过资方id 查找资产计划开关
     * @param corpPolicyId
     * @return
     */
    @Override
    public FundingCorpPolicy findFundingCorpPolicyByCorpPolicyId(Long corpPolicyId) {
        return fundingCorpPolicyRepository.findByFundingCorpId(corpPolicyId);
    }

    /**
     *
     * @param corpPolicyId 资方id
     * @param planDate 资产计划日期 精确到天
     * @return
     */
    @Override
    public FundingAssetAllocationsPrograms findFundingAssetAllocationsProgramsByCorpPolicyIdAndPlanDate(Long corpPolicyId, String planDate) {
        return fundingAssetAllocationsProgramsRepository.findByFundCorpIdAndPlanDate(corpPolicyId, planDate);
    }

    @Override
    public LoanApplicationHistory findLoanApplicationHistoryById(Long loanId) {
        return loanApplicationHistoryRepository.findById(loanId);
    }

    /**
     * 验证资产计划 是否有效
     * @param corpPolicyId
     * @param planDate 日期 只能要天
     * @return
     */
    @Override
    public Boolean validateCorpPolicy(Long corpPolicyId, Date planDate) {
        Boolean isValidate = true;
        FundingCorpPolicy fundingCorpPolicy = findFundingCorpPolicyByCorpPolicyId(corpPolicyId);
        isValidate = isValidate & fundingCorpPolicy.getIsAutoAssign() & fundingCorpPolicy.getIsAutoLoan();

        FundingAssetAllocationsPrograms fundingAssetAllocationsPrograms = findFundingAssetAllocationsProgramsByCorpPolicyIdAndPlanDate(corpPolicyId, DateUtil.format(planDate, DateUtil.YYYY_MM_DD));
        return isValidate & (fundingAssetAllocationsPrograms != null);
    }


    @Override
    public QuotaProduct getXyqbProduct(String productId) {
        if (StringUtils.isEmpty(productId) || "null".equals(productId)) {
            return null;
        }
        return quotaProductRepository.findOne(Long.valueOf(productId));
    }


    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    @Override
    public ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getXyqbOrderStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null && loanId > 1) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);
        final ServiceResult<XyqbCurrentOrderStatusServiceResultModel> orderStatus = xyqbCenter.getOrderStatus(paramMap);
        log.info("[getXyqbOrderStatus]xyqb订单状态查询,creditOrderNumber={},result={}", creditOrderNumber, JSONTools.serialize(orderStatus));
        return orderStatus;
    }

    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    @Override
    public ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getXyqbOrderHistoryStatus(paramMap);
    }

    /**
     * 放款 放款结果通知
     * @param loanId 订单loanId
     * @param expectPayResult 期望放款结果 true 放款成功 false 放款失败
     * @return
     */
    @Override
    public boolean payResultNotify(Long loanId, Boolean expectPayResult) {
        if (Application.isDebug()) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("orderNo", loanId);
            paramMap.put("payOrderNo", loanId);
            paramMap.put("payTime", "");
            paramMap.put("payStatus", expectPayResult ? 3 : 4);
            String result = xyqbCenter.pushLendingResult(paramMap);
            log.info("[放款结果通知]xyqb返回结果result={}", result);
            return "success".equals(result) || "SUCCESS".equals(result);
        } else {
            return false;
        }

    }

    @Override
    public Tuple<Boolean,String> cleanUserActiveOrder(Long userId) {
        ArrayList<String> cancelList = Lists.newArrayList();
        cancelList.add("update xyqb.quota_credit set is_active=0 where user_id=" + userId);
        cancelList.add("update xyqb.quota_account set is_active=0 where user_id=" + userId);
        cancelList.add("update xyqb.loan_application_history set progress=16 where user_id=" + userId);
        cancelList.add("update xyqb.loan_application_history set is_active=0 where user_id=" + userId);
        cancelList.add("delete from apply_quota_record where user_id=" + userId);
        cancelList.add("delete from user_operation_history where user_id=" + userId);

        String cancelResult = jolyneService.executeSQL(JolyneDB.XYQB, JolyneUtil.getJolneSql(cancelList));
        JSONObject resp = JSONObject.parseObject(cancelResult);
        boolean result = (Objects.nonNull(resp) && resp.containsKey("code")) ? "0000".equals(resp.get("code")) : false;
        return new Tuple<>(result,result?"清除用户活跃订单成功":"清除用户活跃订单失败");
    }

    @Override
    public  ServiceResult<RepaymentPlansResultModel> findRepaymentPlan(Long loanId) {
        Map paramMap = Maps.newHashMap();
        paramMap.put("loanId", loanId);
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);
        log.info("查询还款计划,请求参数 paramMap={}", paramMap);
        return xyqbCenter.getXyqbRepaymentPlans(paramMap);
    }

    @Override
    public FinanceProduct getByFundCorpId(Long fundCorpId) {
        return financeProductRepository.findByFundCorpId(fundCorpId);
    }

    @Override
    public ApplyScenarioInfoEntity findFirstByApplyNo(String applyNo) {

        return applyScenarioInfoRepository.findFirstByOrderNo(applyNo);
    }

    @Override
    public QuotaProduct getXyqbProduct(Long channelId) {
        Assert.isNull(channelId, ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
        return quotaProductRepository.findByChannelIdFirstOne(channelId);
    }
}
