package cn.quantgroup.cashloanflowboss.api.login.service;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;

import javax.servlet.http.HttpServletRequest;

/**
 * 获取用户登陆主题信息
 *
 * @author tao
 * @version 2020-08-19 17:22
 */
public interface PrincipalService {

    Principal getPrincipal();

    void pushPrincipal(String token, Principal principal);

    void removePrincipal();

    /**
     * 通过用户名 获取redis中是否已有token存在
     * 如果登陆过，或者登陆未过期 沿用token
     * 保证一个用户  同一时间 只有一个token，可以作用在防止重复登陆上
     * @param username
     * @return
     */
    String getUserBossTokenInRedis(String username);

    /**
     * 从header中获取token
     * @return
     */
    String getUserBossTokenInRequest();
}
