package cn.quantgroup.cashloanflowboss.component.security;

import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.core.exception.ApplicationException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.support.ApplicationObjectSupport;

import java.io.Serializable;

/**
 * Created by WeiWei on 2018/2/1.
 */
public class SecurityInterceptor extends ApplicationObjectSupport implements MethodInterceptor, Serializable {

    @Override
    public Object invoke(final MethodInvocation invocation) throws Throwable {

        Security security = invocation.getMethod().getAnnotation(Security.class);

        if (!this.getApplicationContext().getBean(SecurityHandler.class).doAuthentication(invocation, security.authorityId(), security.authorities())) {
            return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
        }

        return invocation.proceed();

    }

}
