package cn.quantgroup.cashloanflowboss.api.order.service;

import cn.quantgroup.cashloanflowboss.api.channel.entity.boss.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.repository.boss.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.order.model.ApproveVo;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderVo;
import cn.quantgroup.cashloanflowboss.api.order.util.OrderUtil;
import cn.quantgroup.cashloanflowboss.api.user.model.UserSessionInfo;
import cn.quantgroup.cashloanflowboss.api.user.service.UserSessionService;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import cn.quantgroup.cashloanflowboss.spi.clotho.service.ClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.user.service.XyqbUserService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.user.retbean.XUser;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.util.*;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */

@Slf4j
@Service
public class OrderService {

    @Autowired
    private UserSessionService userSessionService;

    @Autowired
    private ChannelConfRepository channelConfRepository;
    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;
    @Autowired
    private XyqbUserService xyqbUserService;
    @Autowired
    private ClothoCenter clothoCenter;



    public Page<OrderVo> getOrders(Long channelId, String channelOrderNo, Integer pageNumber, Integer pageSize) {
        Page<ClfOrderMapping> page = this.clfOrderMappingRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }
            if (StringUtils.isNotEmpty(channelOrderNo)) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), channelOrderNo));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));

        return page.map(it-> {
            OrderVo orderVo = new OrderVo();
            orderVo.setId(it.getId());
            orderVo.setChannelId(it.getRegisteredFrom());
            orderVo.setChannelOrderNumber(it.getChannelOrderNo());
            orderVo.setCreatedAt(it.getCreatedAt().getTime());

            OrderVo.OptButton button = new OrderVo.OptButton();
            button.setAction(OrderVo.OptButtonAction.audit.name());
            button.setName(OrderVo.OptButtonAction.audit.getDesc());

            orderVo.setStatus(OrderVo.OptButtonAction.audit.getDesc());
            orderVo.setOpt(JSONTools.serialize(button));
            orderVo.setMessage("");
            return orderVo;
        });
    }

    public Boolean approveOpt(ApproveVo approveVo) {

        ClfOrderMapping orderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(approveVo.getChannelOrderNumber());
        if (orderMapping == null) {
            log.info("approveOpt,审批失败，无订单 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        UserSessionInfo userSessionInfo = userSessionService.findUserSessionInfo();
        if (!userSessionInfo.getChannelId().equals(orderMapping.getRegisteredFrom())) {

        }

        XUser xUser = xyqbUserService.findXUserById(orderMapping.getQgUserId());
        if (xUser == null) {
            log.info("approveOpt,审批失败，未找到用户 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        ChannelConf channelConf = channelConfRepository.getByChannelId(orderMapping.getRegisteredFrom());
        if (channelConf == null) {
            log.info("approveOpt,审批失败，boss渠道配置为空 channelOrderNumber={}", approveVo.getChannelOrderNumber());
            return false;
        }

        // 额度有效期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(Calendar.DAY_OF_YEAR, 7);

        // 资方 及 期数额度规则
        Integer fundType = approveVo.getFundType();
        Integer fundId;
        if (fundType == 0) {
            fundId = channelConf.getFundId();
        } else {
            fundId = channelConf.getP2pFundId();
        }
        String fundFormat = String.format(OrderUtil.financeProductsFormat, approveVo.getAmount(), approveVo.getAmount(),
                approveVo.getPeriod(), fundId);


        Map<String, Object> data = new HashMap<>(16);
        data.put("code", 0);
        data.put("msg", "success");
        data.put("bizChannel", orderMapping.getRegisteredFrom());
        data.put("uuid", xUser.getUuid());
        data.put("bizNo", orderMapping.getChannelOrderNo());
        data.put("bizType", channelConf.getBizType());
        data.put("auditResult", approveVo.getIsPass());
        data.put("amount", approveVo.getAmount());
        data.put("deadLine", calendar.getTime().getTime());
        data.put("financeProducts", fundFormat);

        String approveResult = clothoCenter.approve(data);
        if ("success".equals(approveResult)) {
            return true;
        } else {
            return false;
        }
    }
}
