package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ChannelEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.CreditStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickModel;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CashWithdrawalService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.utils.BankCardNumberGenerator;
import cn.quantgroup.cashloanflowboss.utils.BankCardTypeEnum;
import cn.quantgroup.cashloanflowboss.utils.BankNameEnum;
import cn.quantgroup.cashloanflowboss.utils.GetEncryptContentAndMd5;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/18.
 */
@Slf4j
@Service
public class CashWithdrawalServiceImpl implements CashWithdrawalService{
    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    OneClickDataRespository oneClickDataRespository;
    @Autowired
    CLFCenterServiceImpl clfCenterService;
    @Autowired
    PhoneInfoService phoneInfoService;
    ClfChannelConfiguration clfChannelConfiguration;
    public static String md5Keywy = "qEAxMJBv";
    public static String aesKeywy = "sxD8KO79EDK0N0AJ";
    /*
    *申请提现请求
    * */
    @Override
    public Result applyLoan(OneClickModel oneClickModel) {
        JSONObject result;
        if(oneClickModel.getChannel().equals(ChannelEnum.ZHANGHZONG.getCode())){
            result= applyZhangZhongLoan(oneClickModel);

        }else if(oneClickModel.getChannel().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            result= null;
        }else if(oneClickModel.getChannel().equals(ChannelEnum.XIAOJUMAO.getCode())){
            result= null;
        }else if(oneClickModel.getChannel().equals(ChannelEnum.GUOMEI.getCode())){
            result= null;
        }else if(oneClickModel.getChannel().equals(ChannelEnum.WEIDIAN.getCode())){
            result= null;
        }else{
            result= null;
        }
        return null;
    }
   /*
   * 掌众的申请提现
   * */
    public JSONObject applyZhangZhongLoan(OneClickModel oneClickModel){
        String url = qapiHttp+"/ex/api/v2/withdraw/ZHANGZHONG";
        //通过手机号获取用户信息

        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        Map<String,String> paras = new HashMap<String, String>();
        //通过手机号获取用户信息
        XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
        Long userId=xUser.getId();
        //从数据库中获取当前的订单
        log.info("getPhone={},CreditStatusEnum={},LoanStatusEnum={}", userId, CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode());
        OneClickData oneClickData=oneClickDataRespository.findByPhoneAndCreditStatusAndLoanStatus(userId.toString().trim(), CreditStatusEnum.CREDIT_SUCC.getCode(), LoanStatusEnum.DEFAULT.getCode());

        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber",oneClickModel.getPhone());
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickModel.getChannel().toString()));
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();
        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);


        return null;
    }

}
