package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.CreditStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickModel;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickOV;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.utils.GetBiNoAndFinanceProducts;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class CreditGrantingServiceImpl implements CreditGrantingService{

    @Autowired
    ApplyLoanService applyLoanService;

    @Autowired
    PhoneInfoService phoneInfoService;

    @Autowired
    OneClickDataRespository oneClickDataRespository;

    public static String txAmount = "2000";
    public static String rate = "0";
    @Value("${clotho.http.net}")
    private String clothoHttp;
    @Override
    public Result authAmountAuditNotify(OneClickModel oneClickModel) throws Exception {
      String  auditResult="true";
        if(oneClickModel.getType().equals("2") ){
            auditResult="true";
        }else if(oneClickModel.getType().equals("3")){
            auditResult="false";
        }else {
            log.info("非授信需要的状态，打印一下oneClickModel.getType()={}",oneClickModel.getType());
        }
            return  applyCreditNotify(oneClickModel,auditResult);
    }

    public Result applyCreditNotify(OneClickModel oneClickModel,String auditResult) throws Exception {
        String url = clothoHttp + "/external/quota/auth_amount_audit/notify";
        Map<String, String> paras = new HashMap<String, String>();
        ArrayList listPara1 =getPublicInfo(oneClickModel);
        paras.put("code", "0");
        paras.put("msg", "success");
        paras.put("bizChannel", "1");
        //通过手机号获取用户信息
       XUser xUser=phoneInfoService.selectUserID(oneClickModel.getPhone());
        String uuid=xUser.getUuid();
        Long userId=xUser.getId();
        paras.put("uuid", uuid);
        //通过用户id获取产品信息
        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(userId);
        log.info("打印quotaCredit={}",quotaCredit);
        int productId= Integer.parseInt(quotaCredit.getProductId().toString().trim()) ;
        String biNo = String.valueOf(quotaCredit.getProductType());
        String quotaRecordOrderNo=quotaCredit.getOrderNo();
        //获取产品分配基础信息，默认rate都是0
        HashMap<Object, Object> getBiNoAndFinanceProduct = GetBiNoAndFinanceProducts.getBiNoAndFinanceProduct(productId, listPara1);

        paras.put("bizNo", quotaRecordOrderNo);
        paras.put("bizType", biNo);
        paras.put("auditResult", auditResult);
        paras.put("amount", oneClickModel.getAmount());
        paras.put("deadLine", "1607746332000");
        paras.put("extData", "null");
        paras.put("otherInformation", "");
        paras.put("financeProducts", getBiNoAndFinanceProduct.get("financeProducts").toString().trim());


        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        // 通过手机号和渠道code获取token
        String getToken=phoneInfoService.getToken(oneClickModel.getPhone(), oneClickModel.getChannel());
        header.put("x-auth-token", getToken);

        log.info("获取paras={},获取header={}",paras,header);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);

        if(result.get("statusCode").toString().trim().equals("200") && result.get("context").toString().trim().equals("success")){
             //从数据库中获取当前的订单
            log.info("getPhone={},CreditStatusEnum={},LoanStatusEnum={}", userId, CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode());
            OneClickData oneClickData=oneClickDataRespository.findByPhoneAndCreditStatusAndLoanStatus(userId.toString().trim(), CreditStatusEnum.DEFAULT.getCode(), LoanStatusEnum.DEFAULT.getCode());

            log.info("获取的实体oneClickData={}",oneClickData);
            //把授信请求通知的数据存放到表one_click_data中
           int update= oneClickDataRespository.updateById(quotaRecordOrderNo, quotaRecordOrderNo, String.valueOf(productId), getToken, oneClickData.getId());
           if (update>0){
               log.info("修改成功update={}",update);
           }else{
               log.info("修改失败 !!!!!");
           }
            return new Result(ApplicationStatus.SUCCESS,new OneClickOV(CreditStatusEnum.DEFAULT.getDesc()),"风控授信回调通知成功");
        }else{
            return Result.buildFail("风控授信回调通知成功失败！！！，请检查数据") ;
        }
    }

    public ArrayList getPublicInfo(OneClickModel oneClickModel){
        ArrayList listPara1 = new ArrayList();
        listPara1.add(0, oneClickModel.getAmount());
        listPara1.add(1, oneClickModel.getTermNo());
        listPara1.add(2, oneClickModel.getFundID());
        listPara1.add(3, rate);
        listPara1.add(4, txAmount);
        return listPara1;

    }
}
