package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.Impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ChannelEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickModel;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.OneClickReslut;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.ApplyLoanService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CreditGrantingService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.OneClickDataOperateService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by shang on 2019/12/9.
 */
@Slf4j
@Service
public class OneClickDataOperateServiceImpl implements OneClickDataOperateService {


    @Autowired
    private ApplyLoanService applyLoanService;
    @Autowired
    private CreditGrantingService creditGrantingService;

    @Override
    public Result OnekeyApply(OneClickModel oneClickModel) {
        return applyLoanService.applyLoan(oneClickModel);
    }

    @Override
    public Result OneKeyCashWithdrawal(OneClickModel oneClickModel) {
        return null;
    }

    @Override
    public Result OneKeyCreditSuccessOrFail(OneClickModel oneClickModel) throws Exception {
        Result creditResult=applyLoanService.applyLoan(oneClickModel);
        if(creditResult.getCode()==200000){
        return   creditGrantingService.authAmountAuditNotify(oneClickModel);

        }else {
            log.info("当前进行进件申请失败oneClickModel={},creditResult={}",oneClickModel,creditResult);
            return creditResult;
        }


    }

    @Override
    public OneClickReslut OneKeyLoanSuccessOrFail(OneClickModel oneClickModel) {
        return null;
    }

}
