package cn.quantgroup.cashloanflowboss.utils.ci;

import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/**
 * Created by shang on 2019/7/26.
 */
@SuppressWarnings("unused")
public class EnvUtil {
    public static final String DSF_CONFIG = System.getProperty("user.dir") + File.separatorChar + "resources"
            + File.separatorChar + "config" + File.separatorChar + "dsf.config";
    private static File DSF_CONFIG_TMP =null;
    private static Map<String,String> sitesMap=new HashMap<String,String>();

    /**
     * �������ò��Ի���
     */
    @SuppressWarnings("unchecked")
    public static void resetEnv() {
        EnvUtil envUtil = new EnvUtil();
//		if (JenkinsUtil.IS_ON_JENKINS) {// Jenkins��ִ��
//			JenkinsUtil jenkinsUtil = new JenkinsUtil();
//			Map<String, String> paraMap = jenkinsUtil.getBuildParameters();
//			if (paraMap != null && paraMap.size() > 0) {
//				String configType = paraMap.get("Config_Type");
//				String server = paraMap.get("Server");
//				String siteMap = paraMap.get("siteMap");
//				if(StringUtils.isNotEmpty(siteMap)){
//					try{
//						sitesMap = (Map<String, String>) JSONObject.parse(siteMap);
//					}catch(Exception e){
//						System.out.println(siteMap+" ��json��ʽ��ֵ��,ת��map�쳣");
//						e.printStackTrace();
//					}
//				}
//				envUtil.resetDsfEnv(sitesMap,configType);
//				if (StringUtils.isNotEmpty(configType)) {
//					if (!configType.equalsIgnoreCase("mirror")&&!configType.equalsIgnoreCase("prod")
//							&&!configType.equalsIgnoreCase("alprod")) {
//						envUtil.resetDubboEnv(configType);
//						envUtil.resetHttpEnv(configType);
//						Logger.log("�����滻����ɹ���configType��%s,server:%s", configType, server);
//					}
//				}
//			}
//		}else{
//			envUtil.resetDsfEnv(sitesMap,"");
//		}
    }

    private void resetHttpEnv(String configType) {
        configType = configType.toLowerCase();
        Properties propertys = System.getProperties();
        Set<Map.Entry<Object, Object>> propertySet = propertys.entrySet();
        for (Map.Entry<Object, Object> property : propertySet) {
            String propertyKey = property.getKey().toString();
            if (propertyKey.toLowerCase().contains("http.")
                    && propertyKey.toLowerCase().contains("." + configType + ".")) {
                String group = propertyKey.split("\\.")[2];
                // �������÷���
                System.setProperty("Http.ENV", group);
                break;
            }
        }
    }

    /**
     * ��������dubbo���Է���
     *
     * @param configType
     */
    private void resetDubboEnv(String configType) {
        configType = configType.toLowerCase();
        Properties propertys = System.getProperties();
        Set<Map.Entry<Object, Object>> propertySet = propertys.entrySet();
        for (Map.Entry<Object, Object> property : propertySet) {
            String propertyKey = property.getKey().toString();
            if (propertyKey.toLowerCase().contains("dubbo.")
                    && propertyKey.toLowerCase().contains("." + configType + ".")) {
                String group = propertyKey.split("\\.")[2];
                // �������÷���
                System.setProperty("Dubbo.ENV", group);
                break;
            }
        }
    }


    public static String getDsfPath(){
        if(DSF_CONFIG_TMP==null){
            Assert.fail("����dsf��ʱ�����ļ�ʧ�ܣ�");
        }
        return DSF_CONFIG_TMP.getAbsolutePath();
    }
    //
    public static String getDubboEnvBySite(String siteName){
        String env = System.getProperty("Dubbo.ENV");
        //JenkinsUtil.IS_ON_JENKINS&&
        if(StringUtils.isNotEmpty(siteName)){
            String ciEnv= getEnvBySite(siteName);
            if(StringUtils.isNotEmpty(ciEnv)){
                Properties propertys = System.getProperties();
                Set<Map.Entry<Object, Object>> propertySet = propertys.entrySet();
                for (Map.Entry<Object, Object> property : propertySet) {
                    String propertyKey = property.getKey().toString();
                    if (propertyKey.toLowerCase().contains(String.format("dubbo.%s.%s.",siteName.toLowerCase(),ciEnv.toLowerCase()))) {
                        // �������÷���
                        env = propertyKey.split("\\.")[2];
                        break;
                    }
                }
            }
        }
        return env;
    }

    public static String getHttpEnvBySite(String siteName){
        String env = System.getProperty("Http.ENV");
        if(StringUtils.isNotEmpty(siteName)){
            String ciEnv= getEnvBySite(siteName);
            if(StringUtils.isNotEmpty(ciEnv)){
                Properties propertys = System.getProperties();
                Set<Map.Entry<Object, Object>> propertySet = propertys.entrySet();
                for (Map.Entry<Object, Object> property : propertySet) {
                    String propertyKey = property.getKey().toString();
                    if (propertyKey.toLowerCase().contains(String.format("http.%s.%s.",siteName.toLowerCase(),ciEnv.toLowerCase()))) {
                        // �������÷���,�����ַ�������Сд
                        env = propertyKey.split("\\.")[2];
                        break;
                    }
                }
            }
        }
        return env;
    }

    private static String getEnvBySite(String siteName){
        String env=null;
        if(StringUtils.isNotEmpty(siteName)){
            siteName=siteName.trim();
            for (Map.Entry<String,String> entry : sitesMap.entrySet()) {
                if(entry.getKey().equalsIgnoreCase(siteName)//�����ּ�Ⱥ����Сд
                        && StringUtils.isNotEmpty(entry.getValue())){
                    env=entry.getValue().toLowerCase();
                    break;
                }
            }
        }
        return env;
    }

    public static void main(String[] args){
        String a = "{\"��Ŀ����\": \"��������\"}";
        EnvUtil env = new EnvUtil();
//
    }
}
