package cn.quantgroup.cashloanflowboss.api.oneclickdata.repository;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by shang on 2019/12/11.
 */
@CashLoanFlowBossDataSource
@Repository
public interface OneClickDataRespository extends JpaRepository<OneClickData, Long> {
//     通过手机号、渠道订单号、授信状态、放款状态查询
    @Query(value = "select * from one_click_data where user_id=?1 and  credit_status = ?2 and loan_status=?3 order by id desc limit 1", nativeQuery = true)
    OneClickData findByPhoneAndCreditStatusAndLoanStatus(String userId,Integer creditStatus,Integer loanStatus);


//    通过id修改 添加订单号 产品id token信息
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update one_click_data set quota_record_order_no=?1,order_no=?2,product_id=?3,token=?4 where id=?5", nativeQuery = true)
    int updateById(String quotaRecordOrderNo,String orderNo,String productId,String token,Long id);
}
