package cn.quantgroup.cashloanflowboss.api.oneclickdata.model;

import lombok.Getter;

/**
 * 放款状态
 * 放款状态：50已申请提现、20等待马上金融放款、21已发送给马上金融, 等待放款、15查看还款计划、16借款完成、28放开失败
 * @author shang
 */
@Getter
public enum LoanStatusEnum {

    DEFAULT(0, "未付款，未核销"),
    LOAN_UNCONFIRM(1, "资金方放款状态未知（未核销）"),
    LOAN_SUCC(15, "放款成功（已核销）"),
    LOAN_FAIL(28, "放款失败（等待退款）"),
    APPLY_WITHDRAWDEPOSIT(50, "已申请提现"),
    WAIT_JRLOAN(20, "等待马上金融放款"),
    TO_JRWAITLOAN(21, "已发送给马上金融, 等待放款"),
    AREADY_REPALYMENT(16, "等待马上金融放款");

    private int code;

    private String desc;

    LoanStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
