package cn.quantgroup.cashloanflowboss.spi.clotho.client;

import cn.quantgroup.cashloanflowboss.spi.clotho.exception.ClothoCenterException;
import java.util.Map;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Map;

/**
 * function:
 * date: 2019/8/9
 *
 * @author: suntao
 */

@Component
@FeignClient(name = "ClothoServiceCenter", url = "${koala.api-host}", fallback = ClothoCenter.Fallback.class)
public interface ClothoCenter {

    @PostMapping(value = "/v1/risk_management/audit/receive_risk_control_result", consumes = "application/x-www-form-urlencoded")
    String approve(@RequestParam Map approveData);

    @PostMapping(value = "/external/quota/order_audit/notify", consumes = "application/x-www-form-urlencoded")
    String orderAuditNotify(@RequestParam Map notify);

    /**
     * 生成放款MQ消息
     *
     * @param data
     * @return
     */
    @PostMapping(value = "/ex/paycenter/pay_notify", consumes = "application/x-www-form-urlencoded")
    String generatorLendingMessage(@RequestParam Map data);

    /**
     * 放款
     *
     * @param data
     * @return
     */
    @PostMapping(value = "clotho/funds/plan/loan/apply", consumes = "application/x-www-form-urlencoded")
    String lending(@RequestParam Map data);

    /**
     * 贷前关单(提现前)
     *
     * @param data
     * @return
     */
    @PostMapping(value = "/loan/super/close/quota", consumes = "application/x-www-form-urlencoded")
    String cancelPreLoan(@RequestParam Map data,@RequestHeader(value = "x-auth-token") String token);

    /**
     * 贷前关单(提现后)
     *
     * @param data
     * @return
     */
    @PostMapping(value = "/loan/super/close", consumes = "application/x-www-form-urlencoded")
    String cancelPreLoanHasLoanId(@RequestParam Map data,@RequestHeader(value = "x-auth-token") String token);

    /**
     * 贷后关单
     *
     * @param data
     * @return
     */
    @PostMapping(value = "/external/huijinsuo/withdraw/test/72", consumes = "application/x-www-form-urlencoded")
    String cancelAfterLoan(@RequestParam Map data);

    @Component
    class Fallback implements ClothoCenter {

        @Override
        public String approve(Map approveData) {
            return "error1";
        }

        @Override
        public String orderAuditNotify(Map notify) {
            return null;
        }

        @Override
        public String generatorLendingMessage(Map data) {
            throw new ClothoCenterException();
        }

        @Override
        public String lending(Map data) {
            return null;
        }

        @Override public String cancelPreLoan(Map data, String token) {
            return null;
        }

        @Override public String cancelPreLoanHasLoanId(Map data, String token) {
            return null;
        }

        @Override public String cancelAfterLoan(Map data) {
            return null;
        }
    }
}
