package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.ApplyRequestApplyTypeEnum;
import lombok.Data;
import lombok.Getter;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * Created with suntao on 2018/5/24
 */
@Data
@Entity
@Table(name = "apply_request_history", catalog = "cash_loan_flow")
public class ApplyRequestHistory {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "request_id")
    private String requestId;

    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "user_name")
    private String userName;

    @Column(name = "uuid")
    private String uuid;

    @Column(name = "id_no")
    private String idNo;

    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "product_id")
    private String productId;

    @Column(name = "is_success")
    private Boolean isSuccess;

    @Column(name = "description_value")
    private String descriptionValue;

    @Column(name = "description_detail")
    private String descriptionDetail;

    @Column(name = "id_type")
    private int idType = 0;

    @Column(name = "apply_type")
    private ApplyRequestApplyTypeEnum applyType;

    @Column(name = "request_type")
    private int requestType;

    @Column(name = "md5")
    private String md5;

    @Column(name = "channel_order_no")
    private String channelOrderNo;

    @Column(name = "order_mapping_id")
    private Long orderMappingId;

    @Column(name = "ext_data")
    private String extData;

    @Column(name = "created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());


    public enum ApplyRequestTypeEnum {
        IN,
        FAIL,
        SUCC
    }

    @Getter
    public enum DescriptionValueEnum {

        phone_idNo_mismatching("0002"),// 手机号 对应身份证与库存不匹配
        credit_30_day_refuse("1003"),// 30/35天内被拒绝过
        has_credit_apply("0004"),//, msg："已有授信订单"
        crediting("0006"),//, msg："授信处理中"
        approving("0007"),//, msg："系统审核中"
        account_exsit("0008");//, msg："已有额度"

        private String value;
        private DescriptionValueEnum(String value) {
            this.value = value;
        }
    }

}
