package cn.quantgroup.cashloanflowboss.api.manytomany;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Random;

/**
 * @author Wang Xiangwei
 * @version 2020/3/10
 */
@RestController
@RequestMapping("/test")
public class TestController123 {

    @Autowired
    private StudentRepository studentRepository;

    @Autowired
    private TeacherRepository teacherRepository;

    @GetMapping("/add/teacher/relation/{id}")
    public String test1(@PathVariable Long id){
        Student one = studentRepository.findOne(id);
        List<Teacher> all = teacherRepository.findAll();
        one.setTeachers(all);
        studentRepository.save(one);
        return "www";
    }


    @GetMapping("/del/student/{id}")
    public String test2(@PathVariable Long id){
        studentRepository.delete(id);
        return "www";
    }

    @GetMapping("/del/teacher/{id}")
    public String test3(@PathVariable Long id){
        teacherRepository.delete(id);
        return "www";
    }

    @GetMapping("/add/student")
    public String test4(){
        Student student = new Student();
        Random random = new Random();
        student.setName(random.nextInt()+"");

        studentRepository.save(student);
        return "ww";
    }

    @GetMapping("/add/teacher")
    public String test5(){
        Teacher student = new Teacher();
        Random random = new Random();
        student.setName(random.nextInt()+"");

        teacherRepository.save(student);
        return "ww";
    }

    @GetMapping("/add/student/relation/{id}")
    public String test6(@PathVariable Long id){
        List<Student> all = studentRepository.findAll();
        Teacher one = teacherRepository.findOne(id);
        one.setStudents(all);
        teacherRepository.save(one);
        return "ww";
    }




}
