package cn.quantgroup.cashloanflowboss.api.manytomany;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.persistence.*;
import java.util.List;

/**
 * @author Wang Xiangwei
 * @version 2020/3/10
 */
@Data
@Entity
@Table(name = "student")
public class Student {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "name")
    private String name;

    @ManyToMany(cascade = { CascadeType.MERGE })
    @JsonIgnore
    @JoinTable(name = "student_teacher", joinColumns = { @JoinColumn(name = "student_id", referencedColumnName = "id") }, inverseJoinColumns = {
            @JoinColumn(name = "teacher_id", referencedColumnName = "id") })
    private List<Teacher> teachers;
}
