package cn.quantgroup.cashloanflowboss.component.route;

import cn.quantgroup.cashloanflowboss.api.order.service.MoOrderServiceImpl;
import cn.quantgroup.cashloanflowboss.api.order.service.OrderService;
import cn.quantgroup.cashloanflowboss.api.order.service.OrderServiceImpl;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 接口实现类路由
 *
 * @author Wang Xiangwei
 * @version 2020/5/26
 */
@Component
public class ServiceRoute {

    @Value("${middle.stage.channel}")
    String channelStr;


    List<String> middleStageChannel;


    @PostConstruct
    public void init() {
        middleStageChannel = Arrays.asList(channelStr.split(","));
    }

    @Autowired
    private ClfOrderMappingRepository orderMappingRepository;


    public OrderService routeOrderService(Long channelId, String channelOrderNumber, Long loanId) {
        if (channelId != null && middleStageChannel.contains(channelId.toString())) {
            return Application.getBean(MoOrderServiceImpl.class);
        }

        if (StringUtils.isNotBlank(channelOrderNumber)) {
            ClfOrderMapping orderMapping = orderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
            if (Objects.nonNull(orderMapping) && middleStageChannel.contains(orderMapping.getRegisteredFrom().toString())) {
                return Application.getBean(MoOrderServiceImpl.class);
            }
        }

        if (Objects.nonNull(loanId)) {
            ClfOrderMapping orderMapping = orderMappingRepository.findByLoanId(loanId);
            if (Objects.nonNull(orderMapping) && middleStageChannel.contains(orderMapping.getRegisteredFrom().toString())) {
                return Application.getBean(MoOrderServiceImpl.class);
            }
        }
        //默认返回
        return Application.getBean(OrderServiceImpl.class);
    }
}
