package cn.quantgroup.cashloanflowboss.spi.xyqb.service;

import cn.quantgroup.cashloanflowboss.api.order.model.XyqbCurrentOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.api.order.model.XyqbHistoryOrderStatusServiceResultModel;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import cn.quantgroup.cashloanflowboss.spi.xyqb.client.XYQBCenter;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.Contract;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundLending;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundingAssetAllocationsPrograms;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundingCorpPolicy;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.*;
import cn.quantgroup.cashloanflowboss.spi.xyqb.util.SignUtil;
import cn.quantgroup.cashloanflowboss.utils.DateUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Slf4j
@Service
public class XYQBCenterService {

    @Autowired
    private FundLendingRepository fundLendingRepository;
    @Autowired
    private ContractRepository contractRepository;
    @Autowired
    private CancelPreLoanRepository cancelPreLoanRepository;
    @Autowired
    private FundingCorpPolicyRepository fundingCorpPolicyRepository;
    @Autowired
    private FundingAssetAllocationsProgramsRepository fundingAssetAllocationsProgramsRepository;


    @Value("${debug.model}")
    public Boolean debugModel;

    @Autowired
    private XYQBCenter xyqbCenter;

    /**
     * 更新资方待放款创建时间
     *
     * @return
     */
    public boolean updateFundLendingTime(Long loanId) {
        return this.fundLendingRepository.updateCreateTime(loanId, new Date());
    }

    /**
     * 更新合同状态
     *
     * @param userId
     * @return
     */
    @Transactional
    public int updateContractStatus(Long userId, Integer status) {
        return this.contractRepository.updateContractStatus(userId, status);
    }

    /**
     * 查询放款记录
     *
     * @param fundId
     * @param progress
     * @return
     */
    public Map queryLendingRecordCount(Integer fundId, Integer progress) {
        return this.fundLendingRepository.queryLendingRecordCount(fundId, progress);
    }


    /**
     * 贷前取消借款
     * @param channelOrderNumber
     * @return
     */
    public Long cancelPreLoan(String channelOrderNumber) {
        return cancelPreLoanRepository.cancelPreLoan(channelOrderNumber);
    }


    /**
     * 通过userId获取合同
     * @param userId
     * @return
     */
    public Contract findContractByUserId(Long userId) {
        return contractRepository.findByUserIdLastOne(userId);
    }

    /**
     * 保存合同
     * @param contract
     */
    public void saveContract(Contract contract) {
        contractRepository.save(contract);
    }

    public FundLending findFundLendingByLoanId(Long loanId) {
        return fundLendingRepository.findByLoanId(loanId);
    }

    public void saveFundLending(FundLending fundLending) {
        fundLendingRepository.save(fundLending);
    }


    /**
     * 通过资方id 查找资产计划开关
     * @param corpPolicyId
     * @return
     */
    public FundingCorpPolicy findFundingCorpPolicyByCorpPolicyId(Long corpPolicyId) {
        return fundingCorpPolicyRepository.findByFundingCorpId(corpPolicyId);
    }

    /**
     *
     * @param corpPolicyId 资方id
     * @param planDate 资产计划日期 精确到天
     * @return
     */
    public FundingAssetAllocationsPrograms findFundingAssetAllocationsProgramsByCorpPolicyIdAndPlanDate(Long corpPolicyId, String planDate) {
        return fundingAssetAllocationsProgramsRepository.findByFundCorpIdAndPlanDate(corpPolicyId, planDate);
    }

    /**
     * 验证资产计划 是否有效
     * @param corpPolicyId
     * @param planDate 日期 只能要天
     * @return
     */
    public Boolean validateCorpPolicy(Long corpPolicyId, Date planDate) {
        Boolean isValidate = true;
        FundingCorpPolicy fundingCorpPolicy = findFundingCorpPolicyByCorpPolicyId(corpPolicyId);
        isValidate = isValidate & fundingCorpPolicy.getIsAutoAssign() & fundingCorpPolicy.getIsAutoLoan();

        FundingAssetAllocationsPrograms fundingAssetAllocationsPrograms = findFundingAssetAllocationsProgramsByCorpPolicyIdAndPlanDate(corpPolicyId, DateUtil.format(planDate, DateUtil.YYYY_MM_DD));
        return isValidate & (fundingAssetAllocationsPrograms != null);
    }

    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public ServiceResult<XyqbCurrentOrderStatusServiceResultModel> getXyqbOrderStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getOrderStatus(paramMap);
    }

    /**
     * 查询订单当前状态
     * @param creditOrderNumber
     * @param loanId
     * @return
     */
    public ServiceResult<XyqbHistoryOrderStatusServiceResultModel> getXyqbOrderHistoryStatus(String creditOrderNumber, Long loanId) {

        Map paramMap = Maps.newHashMap();
        paramMap.put("orderNo", creditOrderNumber);
        if (loanId != null) {
            paramMap.put("loanId", loanId);
        }
        paramMap = SignUtil.sign(SignUtil.KA_API_KEY, paramMap);

        return xyqbCenter.getXyqbOrderHistoryStatus(paramMap);
    }

    /**
     * 放款 放款结果通知
     * @param loanId 订单loanId
     * @param expectPayResult 期望放款结果 true 放款成功 false 放款失败
     * @return
     */
    public boolean payResultNotify(Long loanId, Boolean expectPayResult) {
        if (debugModel) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("orderNo", loanId);
            paramMap.put("payOrderNo", loanId);
            paramMap.put("payTime", "");
            paramMap.put("payStatus", expectPayResult ? 3 : 4);
            String result = xyqbCenter.pushLendingResult(paramMap);
            log.info("[放款结果通知]xyqb返回结果result={}", result);
            return "success".equals(result);
        } else {
            return false;
        }

    }




}
