package cn.quantgroup.cashloanflowboss.api.role.entity;

import cn.quantgroup.cashloanflowboss.api.permissionmodule.entity.Permission;
import cn.quantgroup.cashloanflowboss.core.persistence.Primary;
import lombok.Data;

import javax.persistence.*;
import java.util.List;
import java.util.function.UnaryOperator;

/**
 * Created by WeiWei on 2019/7/30.
 */
@Data
@Entity
@Table(name = "role")
public class Role extends Primary implements UnaryOperator<Role> {

    /**
     * 父角色
     */
    @OneToOne
    @JoinColumn(name ="parent_id")
    private Role parent;

    /**
     * 角色名称
     */
    @Column(name = "name")
    private String name;

    /**
     * 授权列表
     */
    //@Convert(converter = PermissionListConverter.class)
    //@Column(name = "permissions")
    //private List<Permission> permissions;
    /**
     * 权限
     */
    @OneToMany(fetch = FetchType.EAGER)
    @JoinTable(name = "role_permission_mapping", joinColumns = @JoinColumn(name = "role_id"), inverseJoinColumns = @JoinColumn(name = "permission_id"))
    private List<Permission> permissions;


    @Override
    public Role apply(Role role) {
        return this.getParent();
    }

}
