package cn.quantgroup.cashloanflowboss.api.login.service;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @author tao
 * @version 2020-08-19 17:23
 */
@Component
public class PrincipalServiceImpl implements PrincipalService {

    @Autowired
    private HttpServletRequest request;

    @Resource(name = "redisTemplate")
    private ValueOperations<String, Principal> loginOperations;

    @Override
    public Principal getPrincipal() {
        String bossToken = Application.getBossToken(request);
        if (StringUtils.isNotEmpty(bossToken)) {
            return loginOperations.get(bossToken);
        }
        return null;
    }

    @Override
    public void pushPrincipal(String token, Principal principal) {
        loginOperations.set(token, principal, 12, TimeUnit.HOURS);
    }

    @Override
    public void removePrincipal() {
        String bossToken = Application.getBossToken(request);
        if (StringUtils.isNotEmpty(bossToken)) {
            loginOperations.getOperations().delete(bossToken);
        }
    }


}
