package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;


/**
 * Created by WeiWei on 2019/8/12.
 */
@XYQBDataSource
@Repository
public interface LoanApplicationHistoryRepository extends CrudRepository<LoanApplicationHistory, Integer> {

    LoanApplicationHistory findById(Long id);

    @Query(value = "select * from loan_application_history where id=?1 or user_id= ?1 order by id desc limit 1", nativeQuery = true)
    LoanApplicationHistory findByIdOrUserId(Long id);

    @Query(value = "select * from loan_application_history where user_id= ?1 and business_type= ?2 and is_active= 1 order by id desc limit 1", nativeQuery = true)
    LoanApplicationHistory findByUserIdAndBusinessTypeAndIsActive(Long userId,Integer businessType);
}