package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import cn.quantgroup.cashloanflowboss.spi.xyqb.model.RepaymentStatusEnum;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Created by springning on 15-7-21.
 */
@Data
@Entity
@Table(name = "repayment_plan")
public class RepaymentPlan implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "loan_application_manifest_history_id")
    private Long loanAppManifestHistoryId;

    @Column(name = "loan_application_history_id")
    private Long loanApplicationHistoryId;

    @Column(name = "term_no")
    private Integer termNo;

    @Column(name = "deadline")
    private Date deadline;

    @Column(name = "current_repayment")
    private BigDecimal currentRepayment;

    @Column(name = "required_repayment")
    private BigDecimal requiredRepayment;

    @Column(name = "repayment_status")
    private RepaymentStatusEnum repaymentStatus;

    @Column(name = "created_at")
    private Date createdAt;

    @Column(name = "updated_at")
    private Date updatedAt;

    @Column(name = "repaid_at")
    private Date repaidAt;

    @Column(name = "pay_center_order_no")
    private String payCenterOrderNo = "";

    @Column(name = "repayment_received_at")
    private Date repaymentReceivedAt;

    @Column(name = "remark")
    private String remark;

    @Column(name = "transaction_flow_id")
    private Long transactionFlowId;
    /**
     * 催收减免
     */
    @Column(name = "collection_relief")
    private BigDecimal collectionRelief;

    @Override
    public RepaymentPlan clone() {
        RepaymentPlan plan = new RepaymentPlan();
        plan.setId(id);
        plan.setCurrentRepayment(currentRepayment);
        plan.setCollectionRelief(collectionRelief);
        plan.setDeadline(deadline);
        plan.setLoanApplicationHistoryId(loanApplicationHistoryId);
        plan.setLoanAppManifestHistoryId(loanAppManifestHistoryId);
        plan.setPayCenterOrderNo(payCenterOrderNo);
        plan.setRemark(remark);
        plan.setRepaymentStatus(repaymentStatus);
        plan.setRepaidAt(repaidAt);
        plan.setRepaymentReceivedAt(repaymentReceivedAt);
        plan.setRequiredRepayment(requiredRepayment);
        plan.setTermNo(termNo);
        plan.setUserId(userId);
        return plan;
    }

}
