package cn.quantgroup.cashloanflowboss.api.oneclickdata.service;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FinanceProduct;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

/**
 * Created by shang on 2019/12/3.
 */
public interface PhoneInfoService {
    /**
     * 获取token
     * phone 入参手机号
     * 返回token
     */
    String getToken(String phone,String createdFrom) throws Exception ;



    /**
     * 同步session到xyqb
     * 返回空
     */
    JSONObject sySessionToXYQB(String phone,String createdFrom)  throws Exception;

    /**
     * 查询用户信息通过手机号
     * 返回XUser对象
     */
    XUser selectUserID(String phone);

    /**
     * 实名认证
     */
    JSONObject authIdNo(String phone,String createdFrom)throws Exception;

    /**
     * 授信session同步
     */
    JSONObject creditSession(String productId,String phone,String createdFrom)throws Exception ;

    /**
     * 基础信息
     */
    JSONObject authBasic2(String token)throws Exception ;

    /**
     * 进入上传身份证页
     */
    String authOcrUrl()throws Exception ;

    /**
     * 上传正面
     */
    JSONObject ocrAtuhUp(String ocrToken)throws Exception ;

    /**
     * 上传负面
     */
    JSONObject ocrAtuhDown(String ocrToken)throws Exception ;

    /**
     * 提交拍照认证
     */
    JSONObject ocrSubmit(String ocrToken)throws Exception ;

    /**
     * 查询授信中心ID
     */
    void getSpiderCenter();

    /**
     * 授信
     */
    void spiderC() ;

    /**
     * 提交审核
     */
    JSONObject submitAuth(String token)throws Exception ;

    /**
     * 查询用户审核记录
     */
    QuotaCredit selectUserAuditRecords(Long qgUserId,Long channel);

    /**
     * 查询用户审核记录
     */
    QuotaCredit selectUserAuditRecordsNotCreditStatus(Long qgUserId,Long channel);

    /**
     * 查询用户审核记录
     */
    QuotaCredit selectUserAuditRecords(String applyNo);

    /**
     * 授信完成通知xyqb
     */
    JSONObject spiderFinishNotic(String quotaRecordOrderNo,String  channel);

    /**
     * 爬虫授权完成通知 xyqb
     */
    JSONObject spiderReportFinishNotic(String quotaRecordOrderNo);

    /**
     * 800 修改配额产品类型
     */
    void updat800QouteProductType();

    /**
     * 通过fundCorpId返回
     */
    List<FinanceProduct> getFinanceProduct(Long fundCorpId);
}
