package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FinanceProduct;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;


/**
 * @author lupeng
 * @since 2020/04/23
 */
@XYQBDataSource
@Repository
public interface FinanceProductRepository extends JpaRepository<FinanceProduct, Long> {

    @Query(value = "select * from finance_product where fund_corp_id = ?1 and is_active = 1 limit 1", nativeQuery = true)
    FinanceProduct findByFundCorpId(Long fundCorpId);


}
