package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;


import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.LoanStatusEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.TypeEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.*;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * Created by shang on 2019/12/12.
 */
@Slf4j
@Service
public class OneClickDataOperateJobServiceImpl implements OneClickDataOperateJobService {

    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private LoanOperationService loanOperationService;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CreditGrantingService creditGrantingService;
    @Autowired
    private OneClickDataQueueOperateService oneClickDataQueueOperateService;
    @Override
    public void excuteCreditSuccessJob() {

    }

    @Override
    public void excuteCreditFailJob() {

    }

    @Override
    public void excuteSelectCreditStatusJob() {
        //查找请求类型：2授信成功、3授信失败、4放款成功、5放款失败、6清算的单,7提现，并且当前的授信状态是0授信中

        List<OneClickData>  oneClickDataList=oneClickDataRespository.findByCreditStatusAndTypeNotIn(0, 1);
        if(oneClickDataList.size()>0 || oneClickDataList !=null) {

            for (OneClickData oneClickData : oneClickDataList) {
                // 当前授信中的单在apply_quota 查看状态是apply_status=1 时间倒序,进行授信请求操作
                log.info("打印一下oneClickData.getUserId()={},oneClickData.getChannelCode()={}",oneClickData.getUserId(),oneClickData.getChannelCode());
                QuotaCredit quotaCredit1 = phoneInfoService.selectUserAuditRecords(Long.parseLong(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
                if (Objects.isNull(quotaCredit1)) {
                    log.info("不符合授信审核申请的条件");
                } else {
                    //如何条件的单进行授信申请请求
                    log.info("符合授信审核申请的条件oneClickData={},quotaCredit1={}", oneClickData, quotaCredit1);
                    try {
                        creditGrantingService.authAmountAuditNotifyMq(oneClickData, quotaCredit1);

                    } catch (Exception e) {
                        log.info("进入异常e={}", e);
                    }
                }
            }
        }else{
            log.info("oneClickDataList为空={}",oneClickDataList);
        }


    }

    @Override
    public void excuteFundSucessJob() {

    }

    @Override
    public void excuteFundFailJob() {

    }

    @Override
    public void excuteFundJob() {
        //查找请求类型：4放款成功、5放款失败、6清算的单，并且当前的授信状态是2但是
        List<OneClickData> oneClickDataList = oneClickDataRespository.findByCreditStatusAndTypeNotIn(2, 1, 2, 3, 7);
        if (oneClickDataList.size() > 0 || oneClickDataList != null) {
            for (OneClickData oneClickData : oneClickDataList) {
                log.info("打印一下oneClickData.getUserId()={},oneClickData.getLoanId={}", oneClickData.getUserId(),oneClickData.getLoanId());
                if(StringUtils.isNotEmpty(oneClickData.getLoanId()) || StringUtils.isNotEmpty(oneClickData.getUserId())){
                    String loanOrUserId="";
                    if(StringUtils.isNotEmpty(oneClickData.getLoanId())){
                        loanOrUserId=oneClickData.getLoanId();
                    }else {
                        loanOrUserId=oneClickData.getUserId();
                    }
                    LoanApplicationHistory loanApplicationHistory = loanOperationService.selectLoanIdOrUserId(Long.parseLong(loanOrUserId));
                    if (Objects.isNull(loanApplicationHistory)) {
                        log.info("不符合放款条件的单");
                    } else {

                        log.info("符合放款条件loanApplicationHistory={}", loanApplicationHistory);
                        String progress=loanApplicationHistory.getProgress().getDescription().trim();
                        //提现操作尚未成功，重新操作提现
                        if(LoanProgress.WAITING_FUND.getDescription().equals(progress) ){
                            log.info("二次风控成功：20,未进行金额放款21");

                            oneClickDataQueueOperateService.applyLendingNotifyOnly(oneClickData);
                        }else if( LoanProgress.START_ORDER.getDescription().equals(progress)){
                            log.info("提现完毕50，二次风控没有成功");
                            oneClickDataQueueOperateService.getBingSucc(oneClickData);
                        }else if(LoanProgress.FINAL_SENDED_TO_FUNDING_CORP.getDescription().equals(progress)){
                            try {
                                String payStatus="3";
                                if(oneClickData.getType() == TypeEnum.LOANFAIL.getCode() ){
                                    payStatus="4";
                                }else {
                                    payStatus="3";
                                }
                                loanOperationService.payNotify(oneClickData,payStatus);
                            } catch (Exception e) {
                                log.info("进入异常e={}", e.getMessage());
                            }
                        }else if(LoanProgress.CHECK_REPAYMENT_PLAN.getDescription().equals(progress)){
                            log.info("当前已经是放款状态了，直接修改放款成功15");
                            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.CHECK_REPAYMENT_PLAN.getCode(), oneClickData.getId());

                        }else {
                            log.info("当前的放款状态不对，非20 21 ，请查看数据库状态");
                            oneClickDataRespository.updateLoanStatusById(LoanStatusEnum.LOAN_SCHEDULE_FAIL.getCode(), oneClickData.getId());
                        }
                    }
                }else{

                    log.info("尚未生成放款单，未进入提现环节的错误数据");
                }
        }
        }else{
            log.info("oneClickDataList为空={}",oneClickDataList);
        }
    }

    @Override
    public void excuteSelectFundStatusJob() {

    }
}
