package cn.quantgroup.cashloanflowboss.api.user.entity;

import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserRank;
import cn.quantgroup.cashloanflowboss.api.user.dictionary.UserStatus;
import cn.quantgroup.cashloanflowboss.api.user.model.UserModelVo;
import cn.quantgroup.cashloanflowboss.core.persistence.Primary;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import lombok.Data;
import org.hibernate.annotations.Proxy;
import org.springframework.beans.BeanUtils;

import javax.persistence.*;
import java.util.Collections;
import java.util.Date;

/**
 * Created by WeiWei on 2019/7/22.
 */
@Data
@Entity
@Table(name = "user")
@Proxy(lazy = false)
public class User extends Primary {

    /**
     * 用户名
     */
    @Column(name = "username")
    private String username;

    /**
     * 昵称
     */
    @Column(name = "nickname")
    private String nickname;

    /**
     * 密码
     */
    @Column(name = "password")
    private String password;

    /**
     * 渠道ID
     */
    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "channel_name")
    private String channelName;

    /**
     * 用户级别
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "rank")
    private UserRank rank;

    /**
     * 用户角色列表
     */
    @OneToOne(fetch = FetchType.EAGER)
    @JoinTable(name = "user_role_mapping", joinColumns = @JoinColumn(name = "user_id"), inverseJoinColumns = @JoinColumn(name = "role_id"))
    private Role role;

    /**
     * 用户状态
     */
    @Enumerated(EnumType.STRING)
    @Column(name = "status")
    private UserStatus status;

    /**
     * 最后登录时间
     */
    @Column(name = "last_login_time")
    private Date lastLoginTime;


    public static User valueOf(UserModelVo userModelVo, Role role) {
        if (userModelVo == null) {
            return null;
        }
        User user = new User();
        BeanUtils.copyProperties(userModelVo, user);
        user.setPassword(MD5Tools.md5(userModelVo.getPassword()));
        if (role != null) {
            user.setRole(role);

        }
        return user;
    }
}
