package cn.quantgroup.cashloanflowboss.api.channel.service;

import cn.quantgroup.cashloanflowboss.api.channel.entity.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.model.*;
import cn.quantgroup.cashloanflowboss.api.channel.repository.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.*;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import cn.quantgroup.cashloanflowboss.utils.IgnorePropertiesUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.*;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */

@Service
@Slf4j
public class ChannelConfServiceImpl implements ChannelConfService {

    @Autowired
    private CLFCenterService clfCenterService;

    @Autowired
    private ChannelConfRepository channelConfRepository;



    @Override
    public Page<ChannelListModel> getChannelInfo(Integer pageNumber, Integer pageSize, Long channelId, String channelName) {

        Page<ClfChannelConfiguration> page = clfCenterService.findChannelConfigurationByCriteriaQueryPage(pageNumber, pageSize, channelId, channelName);

        Page<ChannelListModel> channelListModelPage = page.map(it -> {
            ChannelListModel channelListModel = new ChannelListModel();
            channelListModel.setChannelId(it.getRegisteredFrom());
            channelListModel.setChannelName(it.getChannelName());
            channelListModel.setChannelCode(it.getChannelCode());
            channelListModel.setBizType(null);
            channelListModel.setCreatedAt(it.getCreatedAt());
            return channelListModel;
        });

        return channelListModelPage;
    }

    @Override
    public ChannelConfVo getChannelConf(Long channelId) {
        ChannelConf channelConf = channelConfRepository.getByChannelId(channelId);

        ChannelConfVo channelConfVo;
        if (channelConf != null) {
            channelConfVo = ChannelConfUtil.channelConfConvertVOModel(channelConf);
        } else {
            // boss channel_conf 为空，从clf 查询数据
            ClfChannelConfiguration channelConfiguration = clfCenterService.findChannelConfigurationByChannelId(channelId);

            ClfOrderCallBack approve = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.FUAD_ASSIFN_SUCC.name(), channelId);
            ClfOrderCallBack orderStatus = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.FUND_SUCC.name(), channelId);
            ClfOrderCallBack repaymentPlan = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.REPAYMENT.name(), channelId);

            channelConfVo = ChannelConfUtil.getChannelConfVoByClf(channelConfiguration, approve, orderStatus, repaymentPlan);
        }
        List<ChannelApplyInfoStrategy> channelApplyInfoStrategyByChannelId = clfCenterService.findChannelApplyInfoStrategyByChannelId(channelId);
        channelConfVo.setApplyConf(channelApplyInfoStrategyByChannelId);

        ChannelSecurityKey channelSecurityKey = clfCenterService.findChannelSecurityByChannelId(channelId);
        if(Objects.nonNull(channelSecurityKey)){
            channelConfVo.getAddInfo().setPublicKey(channelSecurityKey.getChannelPublicKey());
        }
        return channelConfVo;

    }

    @Override
    public Boolean editChannelConfInfo(ChannelConfVo confVo) {
        ChannelConfBaseModel basicInfo = confVo.getBasicInfo();
        ChannelConfAddModel addInfo = confVo.getAddInfo();

        ChannelConf channelConf = ChannelConfUtil.voModelConfConvertChannelConf(confVo);

        ChannelConf channelConfExsit = channelConfRepository.getByChannelId(basicInfo.getChannelId());

        // cash-loan-flow-boss 库
        if (channelConfExsit == null) {
            // 新保存
            channelConf.setCreateTime(new Date());
            channelConfRepository.save(channelConf);
        } else {
            // 更新数据库 数据
            //BeanUtils.copyProperties(channelConf, channelConfExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConf));
            channelConf.setId(channelConfExsit.getId());
            channelConf.setUpdateTime(new Date());
            channelConfRepository.save(channelConf);
        }

        // clf 库
        ClfChannelConfiguration channelConfiguration = ChannelConfUtil.convert2ClfChannelConfiguration(basicInfo);
        List<ClfOrderCallBack> clfOrderCallBackList = ChannelConfUtil.convert2ClfOrderCallback(basicInfo.getChannelId(), addInfo);
        ClfChannelConfiguration channelConfigurationExsit = clfCenterService.findChannelConfigurationByChannelId(basicInfo.getChannelId());


        if (channelConfigurationExsit == null) {
            // 新保存
            channelConfiguration.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            clfCenterService.saveChannelConfiguration(channelConfiguration);

            ClfCallbackConfiguration clfCallbackConfiguration = ChannelConfUtil.convert2ClfCallbackConfiguration(basicInfo);
            clfCenterService.saveCallbackConfiguration(clfCallbackConfiguration);

            clfCenterService.saveOrderCall(clfOrderCallBackList);
        } else {
            // update
         //   BeanUtils.copyProperties(channelConfiguration, channelConfigurationExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConfiguration));
            channelConfiguration.setId(channelConfigurationExsit.getId());
            clfCenterService.saveChannelConfiguration(channelConfiguration);

            // 更新OrderCallBack
            for (ClfOrderCallBack clfOrderCallBack : clfOrderCallBackList) {
                ClfOrderCallBack orderCallBackExsit = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(clfOrderCallBack.getCallbackStatus().name(), clfOrderCallBack.getRegisteredFrom());
                if (orderCallBackExsit != null) {
                    clfOrderCallBack.setId(orderCallBackExsit.getId());
                }
            }
            clfCenterService.saveOrderCall(clfOrderCallBackList);
        }

        //保存进件配置项

        List<ChannelApplyInfoStrategy> channelApplyInfoStrategyList = confVo.getApplyConf();
        if (CollectionUtils.isNotEmpty(channelApplyInfoStrategyList)) {
            for (ChannelApplyInfoStrategy strategy : channelApplyInfoStrategyList) {
                clfCenterService.saveChannelApplyInfoStrategy(strategy);
            }

        }

        String channelPublicKey = addInfo.getPublicKey();
        ChannelSecurityKey channelSecurityKey = clfCenterService.findChannelSecurityByChannelId(channelConf.getChannelId());
        if(Objects.isNull(channelSecurityKey)){
            channelSecurityKey = new ChannelSecurityKey();
            channelSecurityKey.setIsActive(true);
            channelSecurityKey.setCreatedAt(new Timestamp(System.currentTimeMillis()));
        }
        channelSecurityKey.setChannelPublicKey(channelPublicKey);
        clfCenterService.saveChannelSecurityKey(channelSecurityKey);
        return true;
    }


    @Override
    public List<ChannelModel> getAll() {

        List<ClfChannelConfiguration> all = clfCenterService.findAll();
        List<ChannelModel> channelModelList = new ArrayList<>(all.size());
        all.forEach(e->{
            ChannelModel model = new ChannelModel();
            model.setId(e.getId());
            model.setName(e.getChannelName());
            channelModelList.add(model);
        });
        return channelModelList;

    }

    @Override
    public String exportChannelConf(Long channelId) {

        ClfChannelConfiguration channelConfiguration= clfCenterService.findChannelConfigurationByChannelId(channelId);
        List<CallbackConfiguration> callbackConfigurations = clfCenterService.findCallbackConfigurationByChannelId(channelId);
        List<ChannelApplyInfoStrategy> channelApplyInfoStrategies = clfCenterService.findChannelApplyInfoStrategyByChannelId(channelId);
        ChannelSecurityKey channelSecurityKey = clfCenterService.findChannelSecurityByChannelId(channelId);

        StringJoiner joiner = new StringJoiner("\n");
        if(Objects.nonNull(channelConfiguration)){
            joiner.add(generateInsertSql(channelConfiguration));
        }

        if(CollectionUtils.isNotEmpty(callbackConfigurations)){
            for (CallbackConfiguration callbackConfiguration : callbackConfigurations) {
                joiner.add(generateInsertSql(callbackConfiguration));
            }
        }

        if(CollectionUtils.isNotEmpty(channelApplyInfoStrategies)){
            for (ChannelApplyInfoStrategy channelApplyInfoStrategy : channelApplyInfoStrategies) {
                joiner.add(generateInsertSql(channelApplyInfoStrategy));
            }
        }
        if(Objects.nonNull(channelSecurityKey)){
            joiner.add(generateInsertSql(channelSecurityKey));
        }

        return joiner.toString();
    }


    //生成sql语句
    private String generateInsertSql(Object obj){

        if(Objects.isNull(obj)){
            return null;
        }
        Class<?> clazz = obj.getClass();
        Annotation[] annotations = clazz.getAnnotations();
        if(annotations.length <= 0){
            throw new RuntimeException("类名上没有注解，不能获得表名");
        }

        StringJoiner joiner = new StringJoiner(" ");
        joiner.add("insert into");
        //获得表名
        for (Annotation annotation : annotations) {
            if(annotation instanceof Table){
                //只获得@Table注解的，@Entity有了以后再加
                Table table = (Table) annotation;
                String tableName = table.name();
                joiner.add(tableName);
                break;
            }
        }

        Field[] declaredFields = clazz.getDeclaredFields();

        if(declaredFields.length <= 0){
            throw new RuntimeException("没有字段，不能获得表的列名");
        }


        Map<String,Object> field2Value = new HashMap<>();

        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            Id idAnnotation = declaredField.getAnnotation(Id.class);
            if(Objects.nonNull(idAnnotation)){
                continue;
            }
            Column annotation = declaredField.getAnnotation(Column.class);
            if(Objects.isNull(annotation)){
                log.warn("{}字段没有对应的列",declaredField.getName());
                continue;
            }
            try {
                field2Value.put(annotation.name(),declaredField.get(obj));
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        StringJoiner fields = new StringJoiner(",");
        StringJoiner values = new StringJoiner(",");

        for (Map.Entry<String, Object> entry : field2Value.entrySet()) {
            fields.add(entry.getKey());
            //空值
            if(Objects.isNull(entry.getValue())){
                values.add(null);
                continue;
            }
            //非空值
            Object value = entry.getValue();
            //数字不加引号
            if(value instanceof Number || value instanceof Boolean){
                values.add(value.toString());
                continue;
            }
            //枚举存ordinal 存name的表单独判断
            if(value instanceof Enum){
                Enum e = (Enum)value;
                values.add(e.ordinal()+"");
                continue;
            }
            //其他类型一律按照字符串处理,有问题加if判断
            values.add("'"+value.toString()+"'");
        }

        joiner.add("(");
        joiner.add(fields.toString());
        joiner.add(")");
        joiner.add("values");
        joiner.add("(");
        joiner.add(values.toString());
        joiner.add(");");

        return joiner.toString();

    }

    public static void main(String[] args) {
        StringJoiner joiner = new StringJoiner(",");

        joiner.add("seg");
        joiner.add(null);
        joiner.add("www");
        System.out.println(joiner.toString());
    }

}
