package cn.quantgroup.cashloanflowboss.spi.spiderCenter;

import cn.quantgroup.cashloanflowboss.api.customer.entity.CustomerInfo;
import cn.quantgroup.cashloanflowboss.core.base.ServiceResult;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author Wang Xiangwei
 * @version 2020/7/22
 */
@Component
@FeignClient(name = "OPCenter", url = "${spider.api-host}", fallback = SpiderCenter.Fallback.class)
public interface SpiderCenter {

    @PostMapping(value = "/spider-center/middle_office/ex/import/check_risk_info_data", consumes = "application/x-www-form-urlencoded")
    ServiceResult<List<CustomerInfo.RiskInfo>> getRiskInfoData(@RequestParam Map paramMap);


    @Component
    class Fallback implements SpiderCenter {

        @Override
        public ServiceResult<List<CustomerInfo.RiskInfo>> getRiskInfoData(Map paramMap) {
            return ServiceResult.buildFial();
        }
    }
}
