package cn.quantgroup.cashloanflowboss.api.channel.service;

import cn.quantgroup.cashloanflowboss.api.channel.entity.boss.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.entity.clf.ChannelConfiguration;
import cn.quantgroup.cashloanflowboss.api.channel.repository.boss.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.channel.repository.clf.ChannelConfigurationRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.user.entity.boss.User;
import cn.quantgroup.cashloanflowboss.api.user.model.Pagination;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */

@Service
public class ChannelConfService {

    @Autowired
    private ChannelConfRepository channelConfRepository;

    @Autowired
    private ChannelConfigurationRepository clfChannelConfigurationRepository;



    public Page<ChannelConfiguration> getChannelInfo(Pagination pagination, Integer channelId) {
        if (channelId == null) {
            return clfChannelConfigurationRepository.findAllBy(new PageRequest(pagination.getPageNumber(), pagination.getPageSize()));
        } else {
            ChannelConfiguration channelConfiguration = clfChannelConfigurationRepository.findByRegisteredFrom(channelId);
            Page<ChannelConfiguration> result = null;
            return null;
        }
    }


    public Result getChannelConf(Integer channelId) {
        ChannelConf channelConf = channelConfRepository.getByChannelId(channelId);
        return Result.buildSuccess(ChannelConfUtil.channelConfConvertVOModel(channelConf), "success");
    }


}
