CREATE DATABASE IF NOT EXISTS cash_loan_flow_boss CHARACTER SET utf8 COLLATE utf8_general_ci;

use cash_loan_flow_boss;

CREATE TABLE IF NOT EXISTS  `channel_conf` (
  `id` bigint(64) NOT NULL AUTO_INCREMENT COMMENT '物理主键',
  `channel_id` bigint(8) DEFAULT NULL COMMENT '量化派对渠道标记；渠道号',
  `channel_code` varchar(32) DEFAULT '' COMMENT '渠道code',
  `channel_name` varchar(32) DEFAULT '' COMMENT '渠道code',
  `env` varchar(64) DEFAULT '' COMMENT '测试环境',
  `fund_id` bigint(32) DEFAULT NULL COMMENT '资方id',
  `p2p_fund_id` bigint(32) DEFAULT NULL COMMENT '存管资方id',
  `biz_type` bigint(32) DEFAULT NULL COMMENT '业务产品类型productId',
  `aes_key` varchar(64) DEFAULT NULL COMMENT 'aesKey',
  `md5_key` varchar(64) DEFAULT NULL COMMENT 'md5Key',
  `auth_code` varchar(64) DEFAULT NULL COMMENT '提交授信code',
  `risk_code` varchar(64) DEFAULT NULL COMMENT '提交爬虫数据code',
  `env_path` varchar(64) DEFAULT NULL COMMENT '环境域名',
  `channel_ip` varchar(64) DEFAULT NULL COMMENT '渠道ip',
  `approve_call_back_url` varchar(256) DEFAULT NULL COMMENT '审批回调地址',
  `order_status_call_back_url` varchar(256) DEFAULT NULL COMMENT '订单状态回调地址',
  `repay_result_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款结果回调地址',
  `repayment_plan_call_back_url` varchar(256) DEFAULT NULL COMMENT '还款计划回调地址',
  `message` text,
  `extend_data` text COMMENT '扩展信息',
  `create_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_channel_id` (`channel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='渠道配置表';



# table opt_history_log
# ------------------------------------------------------------


CREATE TABLE IF NOT EXISTS `opt_history_log` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `loan_id` bigint(32) DEFAULT NULL COMMENT '提现单号',
  `channel_id` bigint(32) DEFAULT NULL COMMENT '渠道号',
  `opt_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)名称',
  `opt_enum_name` varchar(64) DEFAULT NULL COMMENT '操作节点(功能)枚举值',
  `opt_user` varchar(64) DEFAULT NULL COMMENT '操作员',
  `opt_log_detail` text,
  `ext_data` text,
  `opt_result` bigint(2) DEFAULT NULL COMMENT '是否成功 1 成功 0 失败',
  `create_time` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='操作记录日志';



# table order_approve
# ------------------------------------------------------------


CREATE TABLE IF NOT EXISTS `order_approve` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `channel_order_number` varchar(64) DEFAULT NULL COMMENT '渠道订单号',
  `credit_number` varchar(64) DEFAULT NULL COMMENT '授信订单号',
  `channel_id` bigint(32) NOT NULL COMMENT '渠道号',
  `fund_id` bigint(16) DEFAULT NULL COMMENT '资方id',
  `fund_type` bigint(2) DEFAULT NULL COMMENT '资方类型0：非存管；1：存管',
  `ext_data` text,
  `create_time` timestamp NOT NULL,
  `update_time` timestamp NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
