package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import javax.persistence.*;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * 渠道申请场景数据实体类
 * @author chenglong.han
 * @date 2020/5/8
 */
@Data
@Entity
@Slf4j
@Table(name = "apply_scenario_info")
public class ApplyScenarioInfoEntity {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 用户id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 授信订单号
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 申请渠道
     */
    @Column(name = "channel_id")
    private Long channelId;

    /**
     * 申请产品id
     */
    @Column(name = "quota_product_id")
    private Long quotaProductId;

    /**
     * 账单出账日
     */
    @Column(name = "bill_day")
    private Integer billDay;

    /**
     * 账单还款日
     */
    @Column(name = "repay_day")
    private Integer repayDay;

    /**
     * 申请金额
     */
    @Column(name = "apply_amount")
    private BigDecimal applyAmount;

    /**
     * 申请期数
     */
    @Column(name = "apply_term")
    private Integer applyTerm;

    /**
     * JSON场景数据
     */
    @Column(name = "scenario_data")
    private String scenarioData;

    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
