package cn.quantgroup.cashloanflowboss.api.role;

import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.role.entity.RoleUser;
import cn.quantgroup.cashloanflowboss.api.role.repository.RoleRepository;
import cn.quantgroup.cashloanflowboss.api.role.repository.RoleUserRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class RoleService {

    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private RoleUserRepository roleUserRepository;


    public Role findRoleByUserId(Long userId) {
        RoleUser roleUser = roleUserRepository.findByUserId(userId);
        Long roleId = roleUser.getRoleId();
        Role role = findRoleByRoleId(roleId);
        return role;
    }


    public Role findRoleByRoleId(Long roleId) {
        return roleRepository.findOne(roleId);
    }

}
