package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRouter;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * @author zhangbin
 * @date 2018/4/10.
 */
@Data
@Entity
@Table(name = "callback_fail_record",catalog = "cash_loan_flow")
public class CallbackFailRecord {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "apply_no")
    private String applyNo;

    @Column(name = "loan_id")
    private Long loanId;

    @Column(name = "progress")
    private LoanProgress progress;

    @Column(name = "term_no")
    private Long termNo;

    @Column(name = "notice_type")
    private KANoticeType noticeType;

    @Column(name = "callback_status")
    private Integer callbackStatus;

    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "retry_times")
    private Integer retryTimes;

    @Column(name = "fail_code")
    private Integer failCode;

    @Column(name = "loan_type")
    private CallbackRouter callbackRouter;

    /**
     * 默认有效
     */
    @Column(name = "is_active")
    private Boolean isActive = Boolean.TRUE;

    /**
     * mq 数据不能保存在fail 表字段中的数据，每个渠道结构不一样，每种mq-notifyType 不一样
     */
    @Column(name = "exdata")
    private String exdata;

    @Column(name = "created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());

    @Column(name = "updated_at")
    private Timestamp updatedAt = new Timestamp(System.currentTimeMillis());


}
