package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.annotation.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRole;
import cn.quantgroup.cashloanflowboss.core.annotation.CheckChannelRoleByChannelOrderNumber;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.ClfOrderMappingRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(Ordered.LOWEST_PRECEDENCE)
public class RoleLoadAspect {

    @Pointcut("execution(* cn.quantgroup.cashloanflowboss.api.channel.controller.*.*(..))")
    private void channelController() {}

    @Pointcut("execution(* cn.quantgroup.cashloanflowboss.api.order.controller.*.*(..))")
    private void orderController() {}

    @Pointcut("channelController() || orderController() ")
    private void doSomeRole() {}

    @Autowired
    private ClfOrderMappingRepository clfOrderMappingRepository;


    @Around(value = "doSomeRole()")
    public Object around(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();

        Principal principal = Application.getPrincipal();
        if (principal == null) {
            try {
                // 没有登录 登录检查控制
                return pjp.proceed(args);
            } catch (Throwable throwable) {
                log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
                return Result.buildFial();
            }
        }

        // 如果是渠道用户登陆 默认加载channelId
        ChannelIdInit annotation = method.getAnnotation(ChannelIdInit.class);
        if (annotation != null && principal.isChannel()) {
            String[] paramNames = ((CodeSignature) pjp.getSignature()).getParameterNames();
            for (int i = 0; i < paramNames.length; i++) {
                if (ChannelConfUtil.channelIdParamName.equals(paramNames[i])) {
                    args[i] = principal.getChannelId();
                }
            }
        }

        // 如果是渠道用户登陆，参数中channelId 不是登陆用户channelId，返回 拒绝请求
        CheckChannelRole checkChannelRole = method.getAnnotation(CheckChannelRole.class);
        if (checkChannelRole != null && principal.isChannel()) {
            Long requestChannelId = -1L;
            if (!checkChannelRole.isObjParam()) {
                String[] paramNames = ((CodeSignature) pjp.getSignature()).getParameterNames();
                for (int i = 0; i < paramNames.length; i++) {
                    // 是简单类型，多个参数 直接参数channelId
                    if (ChannelConfUtil.channelIdParamName.equals(paramNames[i])) {
                        // 找到channelId是第几个参数 i
                        Object requestChannelIdObj = args[i];
                        if (requestChannelIdObj == null) {
                            log.info("[CheckChannelRole]无channelId数据");
                            return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
                        }
                        requestChannelId = Long.valueOf(String.valueOf(requestChannelIdObj));
                        if (!principal.isSameChannel(requestChannelId)) {
                            log.info("[CheckChannelRole]渠道用户，登陆channelId与查询channelId不是同一个");
                            return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
                        }
                    }
                }
            } else {
                Class paramClazz = checkChannelRole.paramClazz();
                if (paramClazz == ChannelConfVo.class) {
                    ChannelConfVo confVo = (ChannelConfVo) args[0];
                    final Long channelIdTemp = confVo.getBasicInfo().getChannelId();
                    if (channelIdTemp == null) {
                        log.info("[CheckChannelRole]无channelId数据");
                        return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
                    }
                    requestChannelId = channelIdTemp;
                }
            }
            if (!principal.isSameChannel(requestChannelId)) {
                log.info("[CheckChannelRole]渠道用户，登陆channelId与查询channelId不是同一个");
                return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
            }
        }
        // ======================================== CheckChannelRole end ==========================================

        // 如果是渠道用户登陆，参数中channelOrderNumber 不是登陆用户channelOrderNumber，返回 拒绝请求
        CheckChannelRoleByChannelOrderNumber checkChannelRoleByChannelOrderNumber = method.getAnnotation(CheckChannelRoleByChannelOrderNumber.class);
        if (checkChannelRoleByChannelOrderNumber != null && principal.isChannel()) {
            String[] paramNames = ((CodeSignature) pjp.getSignature()).getParameterNames();
            String channelOrderNumber = "";
            for (int i = 0; i < paramNames.length; i++) {
                if ("channelOrderNumber".equals(paramNames[i])) {
                    channelOrderNumber = String.valueOf(args[i]);
                }
            }
            if (StringUtils.isEmpty(channelOrderNumber)) {
                log.info("[CheckChannelRoleByChannelOrderNumber]参数channelOrderNumber不能为空");
                return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION);
            }
            ClfOrderMapping clfOrderMapping = clfOrderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
            if (clfOrderMapping == null) {
                log.info("[CheckChannelRoleByChannelOrderNumber]无channelOrderNumber数据，channelOrderNumber={}",channelOrderNumber);
                return Result.buildFial(ApplicationStatus.ARGUMENT_VALID_EXCEPTION, "未找到该订单");
            }
            if (!clfOrderMapping.getRegisteredFrom().equals(principal.getChannelId())) {
                log.info("[CheckChannelRoleByChannelOrderNumber]不是该渠道的订单，channelOrderNumber={}",channelOrderNumber);
                return Result.buildFial(ApplicationStatus.INVALID_AUTHORITY);
            }
        }
        // ======================================== CheckChannelRoleByChannelOrderNumber end ==========================================

        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
            return Result.buildFial();
        }
    }


}
