package cn.quantgroup.cashloanflowboss.spi.clf.repository;

import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.sql.Timestamp;
import java.util.List;

public interface ClfOrderMappingRepository extends PagingAndSortingRepository<ClfOrderMapping, Long>, JpaSpecificationExecutor<ClfOrderMapping> {

    List<ClfOrderMapping> findByChannelOrderNoAndRegisteredFrom(String channelOrderNo, Long registeredFrom);

    ClfOrderMapping findByChannelPaymentNoAndRegisteredFrom(String channelOrderNo, Long registeredFrom);

    List<ClfOrderMapping> findByApplyNo(String applyNo);

    @Query(value = "select * from order_mapping where apply_no =?1 ORDER BY id DESC limit 1", nativeQuery = true)
    ClfOrderMapping findByApplyNoLastOne(String applyNo);

    ClfOrderMapping findByLoanId(long loanApplicationHistoryId);

    ClfOrderMapping findByChannelOrderNoAndChannelPaymentNo(String channelOrderNo, String paymentNo);

    @Query(value = "select * from order_mapping where channel_order_no =?1 AND order_extend like ?2 limit 1", nativeQuery = true)
    ClfOrderMapping findByChannelOrderNoAndChannelPaymentNoInOrderExtend(String channelOrderNo, String channelPaymentNo);

    @Query(value = "select * from order_mapping where loan_id IN ?1 AND registered_from = ?2", nativeQuery = true)
    List<ClfOrderMapping> findChannelOrderNoByLoanIdList(List<String> loanIdList, Long registeredFrom);

    @Query(value = "select * from order_mapping where channel_order_no = ?1 AND registered_from = ?2 ORDER BY id DESC limit 1", nativeQuery = true)
    ClfOrderMapping findByChannelOrderNoAndRegisteredFromLastOne(String channelApplyNo, Long registeredfrom);

    @Query(value = "select * from order_mapping where channel_order_no = ?1 ORDER BY id DESC limit 1", nativeQuery = true)
    ClfOrderMapping findByChannelOrderNoLastOne(String channelApplyNo);

    @Query(value = "select * from order_mapping where loan_id is NULL AND apply_no = ?1", nativeQuery = true)
    ClfOrderMapping findByApplyNoAndLoanIdIsNull(String applyNo);

    @Query(value = "select * from order_mapping where created_at >?1 and created_at <=?2 and registered_from =?3 and order_extend is null", nativeQuery = true)
    List<ClfOrderMapping> findByCreatedAtBeginAndEndAndRegisteredFrom(Timestamp begin, Timestamp end, Long registeredFrom);

    @Query(value = "select * from order_mapping where qg_user_id =?1 and registered_from =?2 ORDER BY id DESC limit 1", nativeQuery = true)
    ClfOrderMapping findByUserIdAndRegisteredFromLastOne(Long qgUserId, Long registeredFrom);


    @Query(value = "select * from order_mapping where apply_no =?1 and registered_from = ?2 ORDER BY id DESC limit 1", nativeQuery = true)
    ClfOrderMapping findByApplyNoAndRegisteredFromLastOne(String applyNo, Long registeredFrom);

    @Query(value = "select * from order_mapping where qg_user_id =?1 and registered_from = ?2 ORDER BY created_at ASC", nativeQuery = true)
    List<ClfOrderMapping> findByQgUserId(Long qgUserId, Long registeredFrom);

    // 监控 begin

    @Query(value = "select om.registered_from,count(1) from order_mapping om where om.created_at > ?1 AND om.created_at <= ?2 group by om.registered_from", nativeQuery = true)
    List<Object[]> findBetweenCreatedAtGroupByRegisteredFrom(Timestamp begin, Timestamp end);

    @Query(value = "select count(1) from order_mapping om where om.created_at > ?1 AND om.created_at <= ?2", nativeQuery = true)
    Integer findBetweenCreatedAt(Timestamp begin, Timestamp end);

    // 监控 end

}