package cn.quantgroup.cashloanflowboss.spi.user.service;

import cn.quantgroup.cashloanflowboss.spi.util.HttpService;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import cn.quantgroup.cashloanflowboss.utils.MD5Tools;
import cn.quantgroup.user.bean.UserInfo;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.user.vo.UserSysResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * Created by Rocky on 2016/6/23.
 */
@Service
public class XyqbUserServiceImpl implements XyqbUserService {

    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(XyqbUserServiceImpl.class);

    @Autowired
    private UserSysService userSysService;
    @Autowired
    private HttpService httpService;
    @Value("${passportapi.http}")
    private String passportapiHttp;
    private static final ObjectMapper MAPPER = new ObjectMapper();


    /**
     * 查询用户
     *
     * @param userId
     * @return XyqbUser
     */
    @Override
    public XUser findXUserById(Long userId) {
        UserSysResult<XUser> userSysResult = userSysService.getService().findUserByUserId(userId);
        if (!userSysResult.isSuccess() || userSysResult.getData() == null) {
            LOGGER.error("用户不存在，userId=[{}]", userId);
            return null;
        }
        return userSysResult.getData();
    }


    @Override
    public XUserDetail findUserDetailByUserId(Long userId) {
        UserSysResult<XUserDetail> userDetailResult = userSysService.getService().findUserDetailByUserId(userId);
        if (!userDetailResult.isSuccess() || userDetailResult.getData() == null) {
            LOGGER.error("[findUserDetailByUserId_{}]向用户中心查询用户详情失败,userId={},result={}", userId, JSONTools.serialize(userDetailResult));
            return null;
        }
        return userDetailResult.getData();
    }

    @Override
    public String getUuid(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) {
            return null;
        }
        UserSysResult<XUser> user = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (Objects.isNull(user) || Objects.isNull(user.getData())) {
            return null;
        }
        return user.getData().getUuid();
    }

    @Override
    public XUser findUserByPhoneNo(String phoneNo) {
        UserSysResult<XUser> xuserResult = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (xuserResult == null || xuserResult.getData() == null || !xuserResult.isSuccess()) {
            LOGGER.info("[findUserByPhoneNo]用户中心无用户信息,phoneNo={}，phoneDd5={}", phoneNo, MD5Tools.md5(phoneNo));
            return null;
        }
        return xuserResult.getData();
    }


    /**
     * 判断是否老用户
     *
     * @param phoneNo 手机号
     * @return 老用户 true；新用户 false
     */
    @Override
    public boolean isOldUser(String phoneNo) {
        UserSysResult<XUser> userData = userSysService.getService().findUserByPhoneNo(phoneNo);
        if (userData == null) {
            LOGGER.error("[user_isOldUser]查询用户失败, phoneNo={}", phoneNo);
            return false;
        }
        if (userData.getData() == null) {
            LOGGER.info("[user_isOldUser]没有查询到用户, phoneNo={}", phoneNo);
            return false;
        } else {
            return true;
        }
    }


    /**
     * 用户detail信息
     */
    @Override
    public UserInfo findUserByUuid(String uuid) {
        UserSysResult<UserInfo> userInfo = userSysService.getService().findUserInfoByUuid(uuid);
        if (!userInfo.isSuccess() || userInfo.getData() == null) {
            return null;
        }
        return userInfo.getData();
    }


}
