package cn.quantgroup.cashloanflowboss;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisHttpSession;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableRedisHttpSession(maxInactiveIntervalInSeconds=10800, redisNamespace = "spring:session:boss:expires")
@EnableTransactionManagement
@SpringBootApplication(scanBasePackages = {"cn.quantgroup.cashloanflowboss"})
@Configuration
@ServletComponentScan
@EnableFeignClients
@EnableAsync(proxyTargetClass = true)
public class Bootstrap {


	@Value("${server.session.timeout}")
	private Integer sessionTimeout;

	public static void main(String[] args) {
		SpringApplication.run(Bootstrap.class, args);
	}

//	@Bean
//	public EmbeddedServletContainerCustomizer containerCustomizer() {
//		return container -> {
//			container.setSessionTimeout(sessionTimeout);// 单位为S
//		};
//	}
}
