package cn.quantgroup.cashloanflowboss.core;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.api.login.service.PrincipalService;
import cn.quantgroup.cashloanflowboss.core.constants.Constants;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationDictionary;
import cn.quantgroup.cashloanflowboss.utils.IpUtil;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by WeiWei on 2017/5/23.
 */
@Slf4j
@Component
public class Application implements ApplicationContextAware, ServletContextAware {

    private static ApplicationContext applicationContext;

    private static ServletContext servletContext;


    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    @Override
    public void setServletContext(ServletContext context) {
        servletContext = context;
    }

    /**
     * 获取应用名称
     *
     * @return
     */
    public static String getApplicationName() {
        return Application.getValue("${spring.application.name}");
    }

    /**
     * 获取应用IP地址
     *
     * @return
     */
    public static String getHost() {
        return Application.getValue("${spring.cloud.client.ipAddress}");
    }

    /**
     * 获取应用端口号
     *
     * @return
     */
    public static String getPort() {
        return Application.getValue("${server.port}");
    }

    /**
     * 是否是测试环境
     *
     * @return
     */
    public static Boolean isDebug() {
        return "true".equals(Application.getValue("${debug.model}"));
    }

    /**
     * 获取配置属性值
     *
     * @param placeHolder
     * @return
     */
    public static String getValue(String placeHolder) {
        return Application.getApplicationContext().getEnvironment().resolvePlaceholders(placeHolder);
    }

    /**
     * 获取Bean
     *
     * @param bean
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> bean) {
        return applicationContext.getBean(bean);
    }

    /**
     * 获取Bean
     *
     * @param bean
     * @param arguments
     * @param <T>
     * @return
     */
    public static <T> T getBean(Class<T> bean, Object... arguments) {
        return applicationContext.getBean(bean, arguments);
    }

    /**
     * 获取Bean
     *
     * @param beanName
     * @param <T>
     * @return
     */
    public static <T> T getBean(String beanName) {
        return (T) applicationContext.getBean(beanName);
    }

    /**
     * 获取Bean
     *
     * @param beanName
     * @param <T>
     * @return
     */
    public static <T> T getBean(String beanName, Object... arguments) {
        return (T) applicationContext.getBean(beanName, arguments);
    }

    /**
     * 发布事件
     *
     * @param event
     */
    public static void publishEvent(ApplicationEvent event) {
        applicationContext.publishEvent(event);
    }

    /**
     * 获取验证器
     *
     * @return
     */
    public static Validator getValidator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    /**
     * 获取用户主要信息
     *
     * @return
     */
    public static Principal getPrincipal() {
//        HttpSession session = getSession();
//        if (Objects.nonNull(session)) {
//            Principal principal = JSONTools.deserialize(String.valueOf(session.getAttribute(ApplicationDictionary.PRINCIPAL)), Principal.class);
//            // log.info("后来访问获取sessionId={},userName={}", session.getId(), principal != null ? principal.getUserInfo().getUsername() : "null");
//            return principal;
//        } else {
//            log.info("后来访问获取session为空");
//            return null;
//        }

        PrincipalService principalService = Application.getBean(PrincipalService.class);
        return principalService.getPrincipal();
    }
    /**
     * 获取用户主要信息
     *
     * @return
     */
    public static HttpSession getSession() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.nonNull(request)) {
            HttpSession session = request.getSession();
            if (Objects.nonNull(session)) {
                log.info(" 后来访问获取sessionId={},requestIp={}", session.getId(), IpUtil.getRemoteIP(request));
                return session;
            }else {
                log.info("session 为空");
            }
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getBossToken(HttpServletRequest request) {
        return request.getHeader(Constants.UI_HEADER_TOKEN);
    }

}
