package cn.quantgroup.cashloanflowboss.component.security;

import org.springframework.aop.support.StaticMethodMatcherPointcut;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

/**
 * Created by WeiWei on 2018/2/1.
 */
class SecurityPointcut<T extends Annotation> extends StaticMethodMatcherPointcut implements Serializable {

    private Class<T> pointcutClass;

    public SecurityPointcut(Class<T> pointcutClass) {
        this.pointcutClass = pointcutClass;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        return method.isAnnotationPresent(this.pointcutClass);
    }

}
