package cn.quantgroup.cashloanflowboss.api.login.service;

import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.constants.Constants;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @author tao
 * @version 2020-08-19 17:23
 */
@Component
public class PrincipalServiceImpl implements PrincipalService {

    @Autowired
    private HttpServletRequest request;

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Resource(name = "redisTemplate")
    private ValueOperations<String, Principal> loginOperations;

    @Override
    public Principal getPrincipal() {
        String bossToken = Application.getBossToken(request);
        if (StringUtils.isNotEmpty(bossToken)) {
            return loginOperations.get(bossToken);
        }
        return null;
    }

    @Override
    public void pushPrincipal(String token, Principal principal) {
        loginOperations.set(token, principal, 12, TimeUnit.HOURS);
    }

    @Override
    public void removePrincipal() {
        String bossToken = Application.getBossToken(request);
        if (StringUtils.isNotEmpty(bossToken)) {
            loginOperations.getOperations().delete(bossToken);
        }
    }

    @Override
    public String getUserBossTokenInRedis(String username) {
        // redis 中用姓名作为key，存的用户登陆token为空
        String token = redisTemplate.opsForValue().get(Constants.USER_NAME_TOKEN + username);
        if (StringUtils.isEmpty(token)) {
            return UUID.randomUUID().toString();
        }
        return token;
    }

    @Override
    public String getUserBossTokenInRequest() {
        return this.request.getHeader(Constants.UI_HEADER_TOKEN);
    }


}
