package cn.quantgroup.cashloanflowboss.spi.koala.service;

import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.constants.Constants;
import cn.quantgroup.cashloanflowboss.spi.clotho.client.ClothoCenter;
import cn.quantgroup.cashloanflowboss.spi.clotho.model.LendingServiceModel;
import cn.quantgroup.cashloanflowboss.spi.koala.client.KoalaCenter;
import cn.quantgroup.cashloanflowboss.spi.model.JsonResult;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

/**
 * Created by WeiWei on 2019/8/12.
 */
@Slf4j
@Service
public class KoalaCenterService {

    @Autowired
    private KoalaCenter koalaCenter;


    public Boolean orderAuditNotify(String uuid, Long loanId, boolean auditResult, int bizType, Long registeredFrom) {
        Map notify = new HashMap();
        notify.put("code", 0);
        notify.put("msg", "success");
        notify.put("bizChannel", registeredFrom);
        notify.put("uuid", uuid);
        notify.put("bizNo", loanId);
        notify.put("bizType", bizType);
        notify.put("auditResult", auditResult);
        notify.put("deadLine",System.currentTimeMillis());
        String result = koalaCenter.orderAuditNotify(notify);
        JsonResult jsonResult = JSONObject.parseObject(result,JsonResult.class);

        return jsonResult.isSuccess();
    }


    /**
     * 生成放款MQ消息
     *
     * @return
     */
    public String generatorLendingMessage(LendingServiceModel lendingServiceModel) {
        return this.koalaCenter.generatorLendingMessage(JSONTools.toMap(lendingServiceModel));
    }

    /**
     * 放款
     *
     * @return
     */
    public boolean lending(Integer fundId, BigDecimal amountLimit, Integer pepoleLimit) {

        if (Application.isDebug()) {
            String data = this.koalaCenter.lending(new HashMap(4) {{
                put("fundingCorpId", fundId);
                put("amountLimit", amountLimit);
                put("peopleLimit", pepoleLimit);
            }});

            JsonResult jsonObject = JSONObject.parseObject(data, JsonResult.class);
            return jsonObject.isSuccess();
        } else {
            return false;
        }

    }


    /**
     * 审批
     * @param approveData
     * @return
     */
    public String approve(Map<String, Object> approveData) {
        if (Application.isDebug()) {
            String result = koalaCenter.approve(approveData);
            JsonResult jsonObject = JSONObject.parseObject(result, JsonResult.class);
            log.info("koala审批结果 result={}",result);
            //返回结果不标准 只能单独判断
            if("0".equals(jsonObject.getCode()) || "0000".equals(jsonObject.getCode())){
                return Constants.SUCCESS;
            }else {
                return Constants.FAIL;
            }
        } else {
            return "error";
        }
    }

    public String cancelPreLoan(Map<Object, Object> data) {
        if (Application.isDebug()) {
            String result = koalaCenter.cancelPreLoan(data);
            log.info("koala贷前关单结果 result={}",result);
            JsonResult jsonObject = JSONObject.parseObject(result, JsonResult.class);
            if(jsonObject.isSuccess()){
                return Constants.SUCCESS;
            }else {
                return Constants.FAIL;
            }
        } else {
            return "error";
        }
    }

    public String cancelAfterLoan(Map<Object, Object> data) {
        if (Application.isDebug()) {
            String result =  koalaCenter.cancelAfterLoan(data);
            log.info("koala贷后关单结果 result={}",result);
            JsonResult jsonObject = JSONObject.parseObject(result, JsonResult.class);
            if(jsonObject.isSuccess()){
                return Constants.SUCCESS;
            }else {
                return Constants.FAIL;
            }
        } else {
            return "error";
        }
    }

    public String cancelPreLoanHasLoanId(Map<Object, Object> data) {
        if (Application.isDebug()) {
            String result =  koalaCenter.cancelPreLoanHasLoanId(data);
            log.info("koala 有loanId贷前关单 result={}",result);
            JsonResult jsonObject = JSONObject.parseObject(result, JsonResult.class);
            if(jsonObject.isSuccess()){
                return Constants.SUCCESS;
            }else {
                return Constants.FAIL;
            }
        } else {
            return "error";
        }
    }


    public static void main(String[] args) {
        String  result = " {\n" +
                "    \"code\":\"0\",\n" +
                "    \"msg\":\"已成功收到编号为 AN000000145976079295717376 订单的风审结果.\",\n" +
                "    \"success\":true\n" +
                "}";

        JsonResult jsonObject = JSONObject.parseObject(result, JsonResult.class);
        String code = jsonObject.getCode();
    }
}
